/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.patterns.templates.ocl.interpreter;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.diffmerge.patterns.core.api.IPatternApplication;
import org.eclipse.emf.diffmerge.patterns.core.api.IPatternBasedBijection;
import org.eclipse.emf.diffmerge.patterns.core.api.IPatternRole;
import org.eclipse.emf.diffmerge.patterns.core.api.locations.ILocation;
import org.eclipse.emf.diffmerge.patterns.core.util.LocationsUtil;
import org.eclipse.emf.diffmerge.patterns.core.util.ModelsUtil;
import org.eclipse.emf.diffmerge.patterns.templates.gen.templatepatterns.TemplatePatternRole;
import org.eclipse.emf.diffmerge.patterns.templates.ocl.IOclEnvironmentCustomizer;
import org.eclipse.emf.diffmerge.patterns.templates.ocl.OclPatternsPlugin;
import org.eclipse.emf.diffmerge.patterns.templates.ocl.interpreter.PatternEnvironmentFactory;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.EnvironmentFactory;
import org.eclipse.ocl.EvaluationEnvironment;
import org.eclipse.ocl.ParserException;
import org.eclipse.ocl.ecore.EcoreFactory;
import org.eclipse.ocl.ecore.OCL;
import org.eclipse.ocl.ecore.OrderedSetType;
import org.eclipse.ocl.ecore.Variable;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.types.OCLStandardLibrary;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OclInterpreter {
    private static final Object DEFAULT_CONTEXT = new Object();
    private static final PatternEnvironmentFactory ENVIRONMENT_FACTORY = new PatternEnvironmentFactory();
    private static OCL __referenceOcl = null;

    private static OCL getReferenceOcl() {
        if (__referenceOcl == null) {
            __referenceOcl = OclInterpreter.createOCL();
        }
        return __referenceOcl;
    }

    protected void addVariable(Environment<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, ?, ?, ?, EClass, EObject> env_p, String name_p, EClassifier type_p) {
        Variable variable = EcoreFactory.eINSTANCE.createVariable();
        variable.setName(name_p);
        variable.setType((Object)type_p);
        env_p.addElement(name_p, (org.eclipse.ocl.expressions.Variable)variable, true);
    }

    private String asOclIdentifier(String name_p) {
        String result = name_p.replaceAll(" ", "");
        result = result.replaceAll(":", "_");
        return result;
    }

    public boolean check(String booleanQuery_p, EObject context_p) throws ParserException {
        OCL.Query query = this.createQuery(booleanQuery_p, (EClassifier)(context_p == null ? null : context_p.eClass()));
        boolean result = query.check((Object)context_p);
        return result;
    }

    public boolean check(String booleanQuery_p, EObject context_p, TemplatePatternRole roleContext_p) throws ParserException {
        OCL.Query query = this.createQuery(booleanQuery_p, roleContext_p, context_p);
        boolean result = query.check((Object)context_p);
        return result;
    }

    private OCL.Query createQuery(String query_p, EClassifier parsingContext_p) throws ParserException {
        OCL ocl = OclInterpreter.createOCL();
        org.eclipse.ocl.ecore.OCLExpression parsed = this.parse(ocl, query_p, parsingContext_p);
        OCL.Query result = ocl.createQuery((OCLExpression)parsed);
        return result;
    }

    private OCL.Query createQuery(String query_p, TemplatePatternRole roleContext_p, EObject context_p) throws ParserException {
        OCL ocl = this.createOCL(roleContext_p, context_p);
        org.eclipse.ocl.ecore.OCLExpression parsed = this.parse(ocl, query_p, roleContext_p);
        OCL.Query result = ocl.createQuery((OCLExpression)parsed);
        return result;
    }

    private static OCL createOCL() {
        OCL result = OCL.newInstance((EnvironmentFactory)ENVIRONMENT_FACTORY);
        result.setEvaluationTracingEnabled(false);
        return result;
    }

    public OCL createOCL(TemplatePatternRole roleContext_p, EObject context_p) {
        OCL result = OclInterpreter.createOCL();
        this.setupEnvironment(result.getEnvironment(), roleContext_p, context_p);
        return result;
    }

    private void enhanceEnvironment(Environment<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, ?, ?, ?, EClass, EObject> env_p, EObject context_p) {
        Collection<IOclEnvironmentCustomizer.VariableSpecification> specs = this.getAdditionalVariables(context_p);
        for (IOclEnvironmentCustomizer.VariableSpecification spec : specs) {
            this.addVariable(env_p, spec.getName(), spec.getType());
        }
    }

    private void enhanceEvaluationEnvironment(EvaluationEnvironment<EClassifier, ?, ?, EClass, EObject> env_p, EObject context_p) {
        Collection<IOclEnvironmentCustomizer.VariableSpecification> specs = this.getAdditionalVariables(context_p);
        for (IOclEnvironmentCustomizer.VariableSpecification spec : specs) {
            env_p.add(spec.getName(), spec.getValue());
        }
    }

    public Object evaluate(String query_p, EObject context_p) throws ParserException {
        OCL.Query query = this.createQuery(query_p, (EClassifier)(context_p == null ? null : context_p.eClass()));
        Object result = query.evaluate(this.nonNull(context_p));
        return result;
    }

    public Object evaluate(String query_p, EObject context_p, TemplatePatternRole roleContext_p, IPatternApplication applicationContext_p) throws ParserException {
        OCL.Query query = this.createQuery(query_p, roleContext_p, context_p);
        this.setupEvaluationEnvironment(query.getEvaluationEnvironment(), roleContext_p, applicationContext_p);
        Object result = query.evaluate(this.nonNull(context_p));
        return result;
    }

    public Object evaluate(String query_p, EObject context_p, TemplatePatternRole roleContext_p, IPatternBasedBijection mapping_p) throws ParserException {
        OCL.Query query = this.createQuery(query_p, roleContext_p, context_p);
        this.setupEvaluationEnvironment(query.getEvaluationEnvironment(), roleContext_p, mapping_p);
        Object result = query.evaluate(this.nonNull(context_p));
        return result;
    }

    private Collection<IOclEnvironmentCustomizer.VariableSpecification> getAdditionalVariables(EObject context_p) {
        IOclEnvironmentCustomizer customizer = OclPatternsPlugin.getDefault().getOclEnvironmentCustomizer();
        Collection<IOclEnvironmentCustomizer.VariableSpecification> result = customizer != null ? customizer.getVariables(context_p) : Collections.emptyList();
        return result;
    }

    public EClassifier getParsingContextFor(TemplatePatternRole role_p) {
        EClassifier result;
        EList templateElements = role_p.getTemplateElements();
        if (templateElements.isEmpty()) {
            result = (EClassifier)this.getStandardLibrary().getOclVoid();
        } else if (templateElements.size() == 1) {
            result = ((EObject)templateElements.get(0)).eClass();
        } else {
            EClass elementType = ModelsUtil.getCommonType((Collection)templateElements);
            OrderedSetType collectionType = EcoreFactory.eINSTANCE.createOrderedSetType();
            collectionType.setElementType((Object)elementType);
            result = collectionType;
        }
        return result;
    }

    public OCLStandardLibrary<EClassifier> getStandardLibrary() {
        return OclInterpreter.getReferenceOcl().getEnvironment().getOCLStandardLibrary();
    }

    private Object nonNull(Object object_p) {
        return object_p == null ? DEFAULT_CONTEXT : object_p;
    }

    private org.eclipse.ocl.ecore.OCLExpression parse(OCL ocl_p, String query_p, TemplatePatternRole roleContext_p) throws ParserException {
        org.eclipse.ocl.ecore.OCLExpression result = this.parse(ocl_p, query_p, this.getParsingContextFor(roleContext_p));
        return result;
    }

    private org.eclipse.ocl.ecore.OCLExpression parse(OCL ocl_p, String query_p, EClassifier parsingContext_p) throws ParserException {
        OCL.Helper helper = ocl_p.createOCLHelper();
        helper.setContext((Object)parsingContext_p);
        org.eclipse.ocl.ecore.OCLExpression parsed = helper.createQuery(query_p);
        return parsed;
    }

    public org.eclipse.ocl.ecore.OCLExpression parse(String query_p, TemplatePatternRole roleContext_p, EObject context_p) throws ParserException {
        OCL ocl = this.createOCL(roleContext_p, context_p);
        org.eclipse.ocl.ecore.OCLExpression parsed = this.parse(ocl, query_p, roleContext_p);
        return parsed;
    }

    public void setupEnvironment(Environment<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, ?, ?, ?, EClass, EObject> env_p, TemplatePatternRole roleContext_p, EObject context_p) {
        Iterator it = roleContext_p.getPattern().getRoles().iterator();
        if (it.hasNext()) {
            TemplatePatternRole currentRole = (TemplatePatternRole)it.next();
            while (it.hasNext() && currentRole != roleContext_p) {
                String identifier = this.asOclIdentifier(currentRole.getName());
                EClassifier variableType = this.getParsingContextFor(currentRole);
                this.addVariable(env_p, identifier, variableType);
                currentRole = (TemplatePatternRole)it.next();
            }
        }
        this.enhanceEnvironment(env_p, context_p);
    }

    public void setupEvaluationEnvironment(EvaluationEnvironment<EClassifier, ?, ?, EClass, EObject> env_p, TemplatePatternRole roleContext_p, IPatternApplication applicationContext_p) {
        Object scopeElement;
        Iterator it = roleContext_p.getPattern().getRoles().iterator();
        if (it.hasNext()) {
            TemplatePatternRole currentRole = (TemplatePatternRole)it.next();
            while (it.hasNext() && currentRole != roleContext_p) {
                ILocation location = applicationContext_p.getLocation((IPatternRole)currentRole);
                List mergeTargets = LocationsUtil.getMergeTargets((ILocation)location);
                Object target = mergeTargets.size() == 1 || !currentRole.isGeneric() ? mergeTargets.get(0) : mergeTargets;
                env_p.add(this.asOclIdentifier(currentRole.getName()), target);
                currentRole = (TemplatePatternRole)it.next();
            }
        }
        EObject contextElement = (scopeElement = applicationContext_p.getScopeElement()) instanceof EObject ? (EObject)scopeElement : null;
        this.enhanceEvaluationEnvironment(env_p, contextElement);
    }

    public void setupEvaluationEnvironment(EvaluationEnvironment<EClassifier, ?, ?, EClass, EObject> env_p, TemplatePatternRole roleContext_p, IPatternBasedBijection mapping_p) {
        Object scopeElement;
        Iterator it = roleContext_p.getPattern().getRoles().iterator();
        if (it.hasNext()) {
            TemplatePatternRole currentRole = (TemplatePatternRole)it.next();
            while (it.hasNext() && currentRole != roleContext_p) {
                ModelsUtil.RList modelElements = new ModelsUtil.RList();
                for (EObject templateElement : currentRole.getTemplateElements()) {
                    EObject modelElement = mapping_p.getCounterpart(templateElement, true);
                    if (modelElement == null) continue;
                    modelElements.add(modelElement);
                }
                String identifier = this.asOclIdentifier(currentRole.getName());
                env_p.add(identifier, modelElements.size() == 1 ? modelElements.get(0) : modelElements);
                currentRole = (TemplatePatternRole)it.next();
            }
        }
        EObject contextElement = (scopeElement = mapping_p.getScopeElement()) instanceof EObject ? (EObject)scopeElement : null;
        this.enhanceEvaluationEnvironment(env_p, contextElement);
    }
}

