/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.bridge.log4j;

import java.util.Collection;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggingEvent;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.diffmerge.bridge.log4j.BridgeConsole;
import org.eclipse.emf.diffmerge.bridge.log4j.IBridgeLogListener;
import org.eclipse.emf.diffmerge.bridge.log4j.Messages;
import org.eclipse.emf.diffmerge.bridge.mapping.util.QueryLoggingMessage;
import org.eclipse.emf.diffmerge.bridge.mapping.util.RuleLoggingMessage;
import org.eclipse.emf.diffmerge.bridge.util.BaseTraceLoggingMessage;
import org.eclipse.emf.diffmerge.bridge.util.structures.IPureStructure;
import org.eclipse.emf.diffmerge.ui.EMFDiffMergeUIPlugin;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.IConsoleView;

public class BridgeLogger
implements IBridgeLogListener {
    protected static final Logger logger = Logger.getLogger(BridgeLogger.class);
    private static BridgeLogger INSTANCE = null;

    private BridgeLogger() {
        this.setupConsole();
    }

    private BridgeConsole createNewConsole(IConsoleManager consoleManager_p) {
        BridgeConsole console = new BridgeConsole(Messages.BridgeLogger_ConsoldeId, null);
        consoleManager_p.addConsoles(new IConsole[]{console});
        console.activate();
        return console;
    }

    private void error(String message_p) {
        BridgeConsole console = this.findConsole();
        console.getErrorStream().println(message_p);
    }

    private BridgeConsole findConsole() {
        IConsoleManager consoleManager = ConsolePlugin.getDefault().getConsoleManager();
        IConsole[] existing = consoleManager.getConsoles();
        int i = 0;
        while (i < existing.length) {
            if (Messages.BridgeLogger_ConsoldeId.equals(existing[i].getName())) {
                BridgeConsole console = (BridgeConsole)existing[i];
                consoleManager.showConsoleView((IConsole)console);
                return console;
            }
            ++i;
        }
        return this.createNewConsole(consoleManager);
    }

    public static BridgeLogger getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new BridgeLogger();
        }
        return INSTANCE;
    }

    private ILabelProvider getLabelProvider() {
        return EMFDiffMergeUIPlugin.getDefault().getAdapterFactoryLabelProvider();
    }

    private void handleDebugEvent(LoggingEvent event_p) {
    }

    private void handleErrorEvent(LoggingEvent event_p) {
        String message = event_p.getMessage().toString();
        this.error(message);
    }

    private void handleFatalEvent(LoggingEvent event_p) {
        String message = event_p.getMessage().toString();
        this.error(message);
    }

    private void handleInfoEvent(LoggingEvent event_p) {
        Object message = event_p.getMessage();
        this.info(message);
    }

    public void handleLoggingEvent(LoggingEvent event_p) {
        Level level = event_p.getLevel();
        switch (level.toInt()) {
            case 10000: {
                this.handleDebugEvent(event_p);
                break;
            }
            case 40000: {
                this.handleErrorEvent(event_p);
                break;
            }
            case 50000: {
                this.handleFatalEvent(event_p);
                break;
            }
            case 20000: {
                this.handleInfoEvent(event_p);
                break;
            }
            case 30000: {
                this.handleWarningEvent(event_p);
                break;
            }
        }
    }

    private void handleQueryLoggingMessage(QueryLoggingMessage message_p) {
        BridgeConsole console = this.findConsole();
        Object queryResult = message_p.getQueryResult();
        if (queryResult instanceof EObject) {
            this.registerObject(console, queryResult);
            String objectLabel = this.getLabelProvider().getText(queryResult);
            message_p.mapObjectToLabel(queryResult, objectLabel);
        } else if (queryResult instanceof IPureStructure) {
            Collection objects = ((IPureStructure)queryResult).asCollection();
            for (Object object : objects) {
                this.registerObject(console, object);
                String sourceName = this.getLabelProvider().getText(object);
                message_p.mapObjectToLabel(object, sourceName);
            }
        }
    }

    private void handleRuleLoggingMessage(RuleLoggingMessage message_p) {
    }

    private void handleTraceLoggingMessage(BaseTraceLoggingMessage message_p) {
        BridgeConsole console = this.findConsole();
        Collection sources = message_p.getCause().getSourceElements();
        Object target = message_p.getTarget();
        this.registerObject(console, target);
        String targetName = this.getLabelProvider().getText(target);
        message_p.mapObjectToLabel(target, targetName);
        for (Object source : sources) {
            this.registerObject(console, source);
            String sourceName = this.getLabelProvider().getText(source);
            message_p.mapObjectToLabel(source, sourceName);
        }
    }

    private void handleWarningEvent(LoggingEvent event_p) {
        String message = event_p.getMessage().toString();
        this.warn(message);
    }

    private void info(Object message_p) {
        if (message_p instanceof BaseTraceLoggingMessage) {
            this.handleTraceLoggingMessage((BaseTraceLoggingMessage)message_p);
        } else if (message_p instanceof QueryLoggingMessage) {
            this.handleQueryLoggingMessage((QueryLoggingMessage)message_p);
        } else if (message_p instanceof RuleLoggingMessage) {
            this.handleRuleLoggingMessage((RuleLoggingMessage)message_p);
        }
        this.findConsole().getInfoStream().println(message_p.toString());
    }

    private void initLimitOutput(BridgeConsole console_p) {
        console_p.setWaterMarks(0, 80000);
        console_p.setConsoleWidth(0);
    }

    private void registerObject(BridgeConsole console_p, Object object_p) {
        if (object_p instanceof EObject) {
            URI objectURI = EcoreUtil.getURI((EObject)((EObject)object_p));
            console_p.getFragmentToURIMap().put(objectURI.fragment(), objectURI.trimFragment());
        }
    }

    private BridgeConsole setupConsole() {
        BridgeConsole console = this.findConsole();
        this.initLimitOutput(console);
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow activeWorkbenchWindow = workbench.getActiveWorkbenchWindow();
        if (activeWorkbenchWindow != null) {
            IWorkbenchPage activePage = activeWorkbenchWindow.getActivePage();
            try {
                IConsoleView view = (IConsoleView)activePage.showView(Messages.BridgeLogger_ConsoldeId);
                view.display((IConsole)console);
            }
            catch (PartInitException ex) {
                logger.error((Object)ex.getStackTrace(), (Throwable)ex);
            }
        }
        return console;
    }

    private void warn(String message_p) {
        BridgeConsole console = this.findConsole();
        console.getWarningStream().println(message_p);
    }
}

