/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.patterns.ui.viewers;

import java.util.Collections;
import java.util.List;
import org.eclipse.emf.diffmerge.patterns.templates.engine.diffmerge.TemplatePatternComparison;
import org.eclipse.emf.diffmerge.patterns.templates.engine.specifications.IRoleSelection;
import org.eclipse.emf.diffmerge.patterns.templates.engine.specifications.TemplatePatternUpdateSpecification;
import org.eclipse.emf.diffmerge.patterns.templates.gen.templatepatterns.TemplatePatternRole;
import org.eclipse.emf.diffmerge.patterns.ui.util.UIUtil;
import org.eclipse.emf.diffmerge.patterns.ui.viewers.ComparisonViewer;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Composite;

public class PatternUpdateComparisonViewer
extends ComparisonViewer {
    private TemplatePatternUpdateSpecification _data;
    protected EditingDomain _editingDomain;

    public PatternUpdateComparisonViewer(Composite parent_p, EditingDomain editingDomain_p, boolean multipleSelection_p, boolean showParents_p) {
        super(parent_p, multipleSelection_p, showParents_p);
        this.addFilter(UIUtil.INSTANCE_VIEWER_FILTER);
        this._editingDomain = editingDomain_p;
    }

    protected TemplatePatternComparison getComparison() {
        return (TemplatePatternComparison)super.getComparison();
    }

    protected Font getFont(EObject element_p, Font defaultFont_p) {
        Font result = null;
        List roles = this._data.getRolesOf(element_p);
        if (roles.contains(this._data.getRole())) {
            result = UIUtil.getBoundElementFont(defaultFont_p);
        } else if (!roles.isEmpty() || this.hasBeenAdded(element_p) || this.hasBeenRemoved(element_p) || this.hasBeenModified(element_p)) {
            result = UIUtil.getBold(defaultFont_p);
        }
        return result;
    }

    protected String getText(EObject element_p, String defaultText_p) {
        String result = defaultText_p;
        if (result != null && this._data.hasDependencies(element_p)) {
            result = UIUtil.markAsDependentElement(result);
        }
        if ((result = super.getText(element_p, result)) != null) {
            List roles = this._data.getRolesOf(element_p);
            if (this.isMultiple(element_p)) {
                result = UIUtil.markAsMultipleElement(result);
            }
            if (!roles.isEmpty()) {
                result = UIUtil.markAsBoundElement(result, roles, Collections.emptyList());
            }
        }
        return result;
    }

    private boolean isMultiple(EObject element_p) {
        boolean result = false;
        if (this._data.getPattern() != null) {
            EObject templateElement = element_p;
            EObject attempt = this._data.getCounterpart(element_p, false);
            if (attempt != null) {
                templateElement = attempt;
            }
            result = this._data.getPattern().getMultiElements().contains((Object)templateElement);
        }
        return result;
    }

    public void setInput(Object input_p) {
        if (input_p instanceof TemplatePatternUpdateSpecification) {
            this._data = (TemplatePatternUpdateSpecification)input_p;
            this._data.addSelectedRoleListener(new IRoleSelection.IRoleChangedListener(){

                public void roleChanged(TemplatePatternRole newRole_p) {
                    PatternUpdateComparisonViewer.this.refresh();
                }
            });
            super.setInput(this._data.getVisualizationComparison());
        } else {
            super.setInput(input_p);
        }
    }
}

