/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.ui.specification.ext;

import java.util.ArrayList;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.diffmerge.api.Role;
import org.eclipse.emf.diffmerge.ui.EMFDiffMergeUIPlugin;
import org.eclipse.emf.diffmerge.ui.specification.IComparisonMethod;
import org.eclipse.emf.diffmerge.ui.specification.IComparisonMethodFactory;
import org.eclipse.emf.diffmerge.ui.util.MiscUtil;
import org.eclipse.emf.diffmerge.ui.viewers.AbstractComparisonViewer;
import org.eclipse.emf.diffmerge.ui.viewers.ComparisonViewer;
import org.eclipse.emf.diffmerge.ui.viewers.IDifferenceCategoryProvider;
import org.eclipse.emf.ecore.provider.EcoreItemProviderAdapterFactory;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IActionBars;

public abstract class AbstractComparisonMethod
implements IComparisonMethod {
    protected IComparisonMethodFactory _factory = null;
    private boolean _initialized = false;
    private EditingDomain _editingDomain = null;
    protected boolean _isDedicatedEditingDomain = false;
    private boolean _verbose = true;

    protected AbstractComparisonMethod() {
    }

    protected void clearResourceSet(ResourceSet resourceSet_p) {
        ArrayList resources = new ArrayList(resourceSet_p.getResources());
        for (Resource resource : resources) {
            for (Adapter adapter : new ArrayList(resource.eAdapters())) {
                if (!(adapter instanceof ECrossReferenceAdapter)) continue;
                resource.eAdapters().remove((Object)adapter);
            }
        }
        for (Resource resource : resources) {
            try {
                if (resource.isLoaded()) {
                    resource.unload();
                }
                resourceSet_p.getResources().remove((Object)resource);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void configure() {
    }

    @Override
    public AbstractComparisonViewer createComparisonViewer(Composite parent_p, IActionBars actionBars_p) {
        ILabelProvider customLP;
        AbstractComparisonViewer result = this.doCreateComparisonViewer(parent_p, actionBars_p);
        IDifferenceCategoryProvider provider = this.getCustomCategoryProvider();
        if (provider != null) {
            result.setCategoryProvider(provider);
        }
        if (result instanceof ComparisonViewer && (customLP = this.getCustomLabelProvider()) != null) {
            ((ComparisonViewer)result).setDelegateLabelProvider(customLP);
        }
        return result;
    }

    protected EditingDomain createEditingDomain() {
        ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        adapterFactory.addAdapterFactory((AdapterFactory)new ResourceItemProviderAdapterFactory());
        adapterFactory.addAdapterFactory((AdapterFactory)new EcoreItemProviderAdapterFactory());
        adapterFactory.addAdapterFactory((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
        return new AdapterFactoryEditingDomain((AdapterFactory)adapterFactory, (CommandStack)new BasicCommandStack());
    }

    public void dispose() {
        ComposedAdapterFactory composed;
        AdapterFactory afForType;
        AdapterFactory af;
        AdapterFactoryEditingDomain afed;
        AdapterFactory af2;
        final EditingDomain domain = this.getEditingDomain();
        if (domain != null && this._isDedicatedEditingDomain) {
            MiscUtil.executeAndForget(domain, new Runnable(){

                @Override
                public void run() {
                    AbstractComparisonMethod.this.clearResourceSet(domain.getResourceSet());
                }
            });
            domain.getCommandStack().flush();
        }
        if (domain instanceof AdapterFactoryEditingDomain && domain.getResourceSet().getResources().isEmpty() && (af2 = (afed = (AdapterFactoryEditingDomain)domain).getAdapterFactory()) instanceof IDisposable) {
            ((IDisposable)af2).dispose();
        }
        if (domain instanceof TransactionalEditingDomain && this._isDedicatedEditingDomain) {
            ((TransactionalEditingDomain)domain).dispose();
        }
        if ((af = EMFDiffMergeUIPlugin.getDefault().getAdapterFactoryLabelProvider().getAdapterFactory()) instanceof ComposedAdapterFactory && (afForType = (composed = (ComposedAdapterFactory)af).getFactoryForType((Object)Resource.class.getPackage())) instanceof ResourceItemProviderAdapterFactory) {
            ResourceItemProviderAdapterFactory ripaf = (ResourceItemProviderAdapterFactory)afForType;
            ripaf.dispose();
        }
    }

    protected AbstractComparisonViewer doCreateComparisonViewer(Composite parent_p, IActionBars actionBars_p) {
        return new ComparisonViewer(parent_p, actionBars_p);
    }

    protected EditingDomain doGetEditingDomain() {
        this._isDedicatedEditingDomain = true;
        return this.createEditingDomain();
    }

    protected IDifferenceCategoryProvider getCustomCategoryProvider() {
        return null;
    }

    protected ILabelProvider getCustomLabelProvider() {
        return null;
    }

    @Override
    public final EditingDomain getEditingDomain() {
        if (!this._initialized) {
            this._editingDomain = this.doGetEditingDomain();
            this._initialized = true;
        }
        return this._editingDomain;
    }

    @Override
    public IComparisonMethodFactory getFactory() {
        return this._factory;
    }

    @Override
    public ResourceSet getResourceSet(Role role_p) {
        return null;
    }

    @Override
    public boolean isConfigurable() {
        return false;
    }

    @Override
    public boolean isDedicatedEditingDomain() {
        return this._isDedicatedEditingDomain;
    }

    @Override
    public boolean isThreeWay() {
        return this.getModelScopeDefinition(Role.ANCESTOR) != null;
    }

    @Override
    public boolean isVerbose() {
        return this._verbose;
    }

    @Override
    public void setEditingDomain(EditingDomain domain_p, boolean dedicated_p) {
        this._editingDomain = domain_p;
        if (domain_p != null) {
            this._isDedicatedEditingDomain = dedicated_p;
            this._initialized = true;
        } else {
            this._isDedicatedEditingDomain = false;
            this._initialized = false;
        }
    }

    @Override
    public void setVerbose(boolean verbose_p) {
        this._verbose = verbose_p;
    }
}

