/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.structures.endo;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.eclipse.emf.diffmerge.structures.IEqualityTester;
import org.eclipse.emf.diffmerge.structures.IProperty;
import org.eclipse.emf.diffmerge.structures.IPropertyValue;
import org.eclipse.emf.diffmerge.structures.PropertyValue;
import org.eclipse.emf.diffmerge.structures.binary.HashBinaryRelation;
import org.eclipse.emf.diffmerge.structures.binary.IRangedBinaryRelation;
import org.eclipse.emf.diffmerge.structures.common.FHashSet;
import org.eclipse.emf.diffmerge.structures.endo.AbstractEndorelation;
import org.eclipse.emf.diffmerge.structures.endo.AbstractIterableEndorelation;
import org.eclipse.emf.diffmerge.structures.endo.IIterableEndorelation;
import org.eclipse.emf.diffmerge.structures.endo.IRangedEndorelation;

public class EditableEndorelation<T>
extends AbstractEndorelation<T>
implements IRangedEndorelation.Editable<T>,
IIterableEndorelation.WithProperties<T> {
    private final IRangedBinaryRelation.Editable<T, T> _contents;

    public EditableEndorelation() {
        this((IEqualityTester)null);
    }

    public EditableEndorelation(IEqualityTester tester_p) {
        super(tester_p);
        this._contents = this.newContents(tester_p);
    }

    public EditableEndorelation(IRangedBinaryRelation.Editable<T, T> state_p) {
        super(state_p.getEqualityTester());
        this._contents = state_p;
    }

    @Override
    public boolean add(T source_p, T target_p) {
        return this.getContents().add(source_p, target_p);
    }

    @Override
    public boolean addAll(T source_p, Collection<? extends T> targets_p) {
        return this.getContents().addAll(source_p, targets_p);
    }

    @Override
    public void clear() {
        this.getContents().clear();
    }

    @Override
    public Collection<T> get(T element_p) {
        return this.getContents().get(element_p);
    }

    protected IRangedBinaryRelation.Editable<T, T> getContents() {
        return this._contents;
    }

    @Override
    public Collection<T> getElements() {
        FHashSet<Object> result = new FHashSet<Object>(this.getEqualityTester());
        result.addAll(this.getContents().getSources());
        result.addAll(this.getContents().getTargets());
        return Collections.unmodifiableSet(result);
    }

    @Override
    public IPropertyValue<Collection<T>> getMaximalElements() {
        Collection<T> sources = this.getSources();
        Collection<T> targets = this.getTargets();
        FHashSet<T> result = new FHashSet<T>(targets, this.getEqualityTester());
        result.removeAll(sources);
        return new PropertyValue<Collection<T>>(result);
    }

    @Override
    public IPropertyValue<Collection<T>> getMinimalElements() {
        Collection<T> sources = this.getSources();
        Collection<T> targets = this.getTargets();
        FHashSet<T> result = new FHashSet<T>(sources, this.getEqualityTester());
        result.removeAll(targets);
        return new PropertyValue<Collection<T>>(result);
    }

    @Override
    public Collection<T> getSources() {
        return this.getContents().getSources();
    }

    @Override
    public Collection<T> getTargets() {
        return this.getContents().getTargets();
    }

    @Override
    public Iterator<T> iterator() {
        return this.getElements().iterator();
    }

    protected IRangedBinaryRelation.Editable<T, T> newContents(IEqualityTester tester_p) {
        return new HashBinaryRelation(this.getEqualityTester());
    }

    @Override
    public IProperty<Collection<T>> propertyMaximalElements() {
        return AbstractIterableEndorelation.PROPERTY_MAXIMAL_ELEMENTS;
    }

    @Override
    public IProperty<Collection<T>> propertyMinimalElements() {
        return AbstractIterableEndorelation.PROPERTY_MINIMAL_ELEMENTS;
    }

    @Override
    public boolean remove(T source_p, T target_p) {
        return this.getContents().remove(source_p, target_p);
    }

    @Override
    public boolean removeElement(T element_p) {
        boolean sourcesModified = this.removeSource(element_p);
        boolean targetsModified = this.removeTarget(element_p);
        return sourcesModified || targetsModified;
    }

    @Override
    public boolean removeSource(T source_p) {
        return this.getContents().removeSource(source_p);
    }

    @Override
    public boolean removeTarget(T target_p) {
        return this.getContents().removeTarget(target_p);
    }
}

