/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.structures.endo;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.eclipse.emf.diffmerge.structures.IEqualityTester;
import org.eclipse.emf.diffmerge.structures.IProperty;
import org.eclipse.emf.diffmerge.structures.IPropertyValue;
import org.eclipse.emf.diffmerge.structures.PropertyValue;
import org.eclipse.emf.diffmerge.structures.common.FHashSet;
import org.eclipse.emf.diffmerge.structures.endo.AbstractIterableEndorelation;
import org.eclipse.emf.diffmerge.structures.endo.BreadthFirstIterator;
import org.eclipse.emf.diffmerge.structures.endo.DepthFirstIterator;
import org.eclipse.emf.diffmerge.structures.endo.IGraphIterator;
import org.eclipse.emf.diffmerge.structures.endo.IRecursivelyDefinedEndorelation;

public abstract class AbstractRecursivelyDefinedEndorelation<T>
extends AbstractIterableEndorelation<T>
implements IRecursivelyDefinedEndorelation.WithProperties<T> {
    public static final IProperty<Collection<?>> PROPERTY_DEPTH = new IProperty<Collection<?>>(){};
    protected final Collection<T> _origins;
    protected final boolean _noMultipleInverseOrCycles;
    protected IPropertyValue<Long> _depth;

    protected AbstractRecursivelyDefinedEndorelation(Collection<? extends T> origins_p, IEqualityTester tester_p) {
        this(origins_p, false, tester_p);
    }

    protected AbstractRecursivelyDefinedEndorelation(Collection<? extends T> origins_p, boolean noMultipleInverseOrCycles_p, IEqualityTester tester_p) {
        super(tester_p);
        this._origins = new FHashSet<T>(origins_p, tester_p);
        this._noMultipleInverseOrCycles = noMultipleInverseOrCycles_p;
        this._depth = PropertyValue.unknownValue();
    }

    @Override
    public IPropertyValue<Long> getDepth() {
        return this._depth;
    }

    @Override
    public Collection<T> getOrigins() {
        return Collections.unmodifiableCollection(this._origins);
    }

    @Override
    public IPropertyValue<Boolean> isWithoutCycles() {
        IPropertyValue<Boolean> result = this._noMultipleInverseOrCycles ? PropertyValue.trueValue() : super.isWithoutCycles();
        return result;
    }

    @Override
    public IPropertyValue<Boolean> isInjective() {
        IPropertyValue<Boolean> result = this._noMultipleInverseOrCycles ? PropertyValue.trueValue() : super.isInjective();
        return result;
    }

    @Override
    public IGraphIterator<T> iterator() {
        return new DepthFirstIterator(this);
    }

    @Override
    public IGraphIterator<T> iterator(boolean depthFirst_p) {
        return depthFirst_p ? new DepthFirstIterator(this) : new BreadthFirstIterator(this);
    }

    @Override
    public void notifyExplored(Iterator<T> iterator_p) {
        super.notifyExplored(iterator_p);
        if (iterator_p instanceof IGraphIterator) {
            IGraphIterator iterator = (IGraphIterator)((Object)iterator_p);
            this._depth = new PropertyValue<Long>(iterator.maxDepth());
        }
    }

    @Override
    public IProperty<Collection<T>> propertyDepth() {
        return PROPERTY_DEPTH;
    }
}

