/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.ui.specification.ext;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.diffmerge.api.IDiffPolicy;
import org.eclipse.emf.diffmerge.api.IMatchPolicy;
import org.eclipse.emf.diffmerge.api.IMergePolicy;
import org.eclipse.emf.diffmerge.api.config.IComparisonConfiguration;
import org.eclipse.emf.diffmerge.api.config.IComparisonConfigurator;
import org.eclipse.emf.diffmerge.impl.policies.ConfigurableDiffPolicy;
import org.eclipse.emf.diffmerge.impl.policies.ConfigurableMatchPolicy;
import org.eclipse.emf.diffmerge.impl.policies.ConfigurableMergePolicy;
import org.eclipse.emf.diffmerge.ui.specification.ext.ConfigurableComparisonMethod;

public class ComparisonConfiguration
implements IComparisonConfiguration,
IComparisonConfigurator.Provider {
    protected boolean _keepMatchIDs;
    protected ConfigurableMatchPolicy _matchPolicy = null;
    protected ConfigurableDiffPolicy _diffPolicy = null;
    protected ConfigurableMergePolicy _mergePolicy = null;
    protected final List<IComparisonConfigurator> _configurators;
    protected boolean _showAdvancedSettings;

    public ComparisonConfiguration(ConfigurableComparisonMethod comparisonMethod_p) {
        IMergePolicy mergePolicy;
        IDiffPolicy diffPolicy;
        IMatchPolicy matchPolicy = comparisonMethod_p.getMatchPolicy();
        boolean bl = this._keepMatchIDs = matchPolicy == null ? false : matchPolicy.keepMatchIDs();
        if (matchPolicy instanceof ConfigurableMatchPolicy) {
            try {
                this._matchPolicy = ((ConfigurableMatchPolicy)matchPolicy).clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
        }
        if ((diffPolicy = comparisonMethod_p.getDiffPolicy()) instanceof ConfigurableDiffPolicy) {
            try {
                this._diffPolicy = ((ConfigurableDiffPolicy)diffPolicy).clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
        }
        if ((mergePolicy = comparisonMethod_p.getMergePolicy()) instanceof ConfigurableMergePolicy) {
            try {
                this._mergePolicy = ((ConfigurableMergePolicy)mergePolicy).clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
        }
        this._configurators = new ArrayList<IComparisonConfigurator>(comparisonMethod_p.getConfigurators());
        this._showAdvancedSettings = this.getCurrentConfigurator() == null;
    }

    protected IComparisonConfigurator getCurrentConfigurator() {
        for (IComparisonConfigurator configurator : this.getConfigurators()) {
            if (!configurator.isCompliant((IComparisonConfiguration)this)) continue;
            return configurator;
        }
        return null;
    }

    public List<IComparisonConfigurator> getConfigurators() {
        return this._configurators;
    }

    public ConfigurableDiffPolicy getDiffPolicy() {
        return this._diffPolicy;
    }

    public ConfigurableMatchPolicy getMatchPolicy() {
        return this._matchPolicy;
    }

    public ConfigurableMergePolicy getMergePolicy() {
        return this._mergePolicy;
    }

    public boolean isKeepMatchIDs() {
        return this._keepMatchIDs;
    }

    public boolean isShowAdvancedSettings() {
        return this._showAdvancedSettings;
    }

    public void setKeepMatchIDs(boolean keep_p) {
        this._keepMatchIDs = keep_p;
        if (this._matchPolicy != null) {
            this._matchPolicy.setKeepMatchIDs(keep_p);
        }
    }

    public void setShowAdvancedSettings(boolean show_p) {
        this._showAdvancedSettings = show_p;
    }
}

