/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.impl.scopes;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.diffmerge.impl.scopes.AbstractEditableModelScope;
import org.eclipse.emf.diffmerge.structures.IEqualityTester;
import org.eclipse.emf.diffmerge.structures.common.FArrayList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class RootedModelScope
extends AbstractEditableModelScope {
    protected final List<EObject> _roots;

    public RootedModelScope(List<? extends EObject> roots_p) {
        this._roots = new FArrayList(roots_p, IEqualityTester.BY_REFERENCE);
    }

    public RootedModelScope(List<EObject> roots_p, boolean operateOnList_p) {
        this._roots = operateOnList_p ? roots_p : new FArrayList((Collection)roots_p, IEqualityTester.BY_REFERENCE);
    }

    @Override
    public boolean add(EObject element_p) {
        return this._roots.add(element_p);
    }

    @Override
    public boolean add(EObject source_p, EReference reference_p, EObject value_p) {
        boolean result = super.add(source_p, reference_p, value_p);
        if (result && this.isContainment(reference_p)) {
            this._roots.remove(value_p);
        }
        return result;
    }

    @Override
    public boolean covers(EObject element_p) {
        return EcoreUtil.isAncestor(this._roots, (EObject)element_p);
    }

    @Override
    public EObject getContainer(EObject element_p) {
        return this.getContents().contains(element_p) ? null : super.getContainer(element_p);
    }

    @Override
    public EReference getContainment(EObject element_p) {
        return this.getContents().contains(element_p) ? null : super.getContainment(element_p);
    }

    @Override
    public List<EObject> getContents() {
        return Collections.unmodifiableList(this._roots);
    }

    @Override
    public boolean remove(EObject element_p) {
        boolean result = super.remove(element_p);
        if (result) {
            this._roots.remove(element_p);
        }
        return result;
    }
}

