/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.repository.ui.viewer;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.dirigible.repository.api.IEntity;
import org.eclipse.dirigible.repository.api.IEntityInformation;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public final class ArtifactPropertySource
implements IPropertySource {
    private static final String PROPERTY_NAME = "Name";
    private static final String PROPERTY_PATH = "Path";
    private static final String PROPERTY_DATE_CREATED = "Created At";
    private static final String PROPERTY_USER_CREATED = "Created By";
    private static final String PROPERTY_DATE_MODIFIED = "Modified At";
    private static final String PROPERTY_USER_MODIFIED = "Modified By";
    SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private final Map<String, Object> properties = new HashMap<String, Object>();

    public ArtifactPropertySource(IEntity entity) {
        IEntityInformation information = null;
        try {
            information = entity.getInformation();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (information != null) {
            this.fillProperties(information);
        }
    }

    private void fillProperties(IEntityInformation information) {
        this.properties.put(PROPERTY_NAME, information.getName());
        this.properties.put(PROPERTY_PATH, information.getPath());
        this.properties.put(PROPERTY_DATE_CREATED, this.dateFormatter.format(information.getCreatedAt()));
        this.properties.put(PROPERTY_USER_CREATED, information.getCreatedBy());
        this.properties.put(PROPERTY_DATE_MODIFIED, this.dateFormatter.format(information.getModifiedAt()));
        this.properties.put(PROPERTY_USER_MODIFIED, information.getModifiedBy());
    }

    public Object getEditableValue() {
        return null;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        int propertyCount = this.properties.size();
        IPropertyDescriptor[] descriptors = new IPropertyDescriptor[propertyCount];
        Iterator<Map.Entry<String, Object>> entryIterator = this.properties.entrySet().iterator();
        int i = 0;
        while (i < propertyCount && entryIterator.hasNext()) {
            Map.Entry<String, Object> entry = entryIterator.next();
            descriptors[i] = ArtifactPropertySource.createDescriptor(entry);
            ++i;
        }
        return descriptors;
    }

    private static IPropertyDescriptor createDescriptor(Map.Entry<String, Object> entry) {
        PropertyDescriptor descriptor = new PropertyDescriptor((Object)entry.getKey(), entry.getKey());
        descriptor.setLabelProvider((ILabelProvider)new LabelProvider(){
            private static final long serialVersionUID = -4014575485655343006L;

            public String getText(Object element) {
                return String.valueOf(element);
            }
        });
        return descriptor;
    }

    public Object getPropertyValue(Object id) {
        return this.properties.get(id);
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
    }
}

