/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.template.ui.common;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.dirigible.ide.template.ui.common.GenerationModel;
import org.eclipse.dirigible.ide.template.ui.common.Messages;
import org.eclipse.dirigible.ide.template.velocity.VelocityGenerator;
import org.eclipse.dirigible.ide.workspace.dual.WorkspaceLocator;
import org.eclipse.dirigible.ide.workspace.ui.viewer.WorkspaceViewerUtils;
import org.eclipse.dirigible.repository.logging.Logger;

public abstract class TemplateGenerator {
    private static final String THE_FILE_ALREADY_EXISTS_SKIPPED_GENERATION_OF = Messages.TemplateGenerator_THE_FILE_ALREADY_EXISTS_SKIPPED_GENERATION_OF;
    private static final Logger logger = Logger.getLogger(TemplateGenerator.class);
    private VelocityGenerator velocityGenerator = new VelocityGenerator();
    private List<IFile> createdFiles = new ArrayList<IFile>();

    protected abstract GenerationModel getModel();

    protected abstract Map<String, Object> prepareParameters();

    protected abstract String getLogTag();

    public void generate() throws Exception {
        this.generateFile(this.getModel().getTemplateLocation(), this.getModel().getTargetLocation(), this.getModel().getFileName());
    }

    public void generateFile(String templateLocation, String targetLocation, String fileName) throws Exception {
        Map<String, Object> parameters = this.prepareParameters();
        InputStream in = this.getClass().getResourceAsStream(templateLocation);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.velocityGenerator.generate(in, (OutputStream)out, parameters, this.getLogTag());
        byte[] bytes = out.toByteArray();
        bytes = this.afterGeneration(bytes);
        IPath location = new Path(targetLocation).append(fileName);
        this.createFile(location, bytes);
    }

    protected byte[] afterGeneration(byte[] bytes) {
        return bytes;
    }

    protected void createFile(IPath location, byte[] bytes) throws Exception {
        IWorkspace workspace = WorkspaceLocator.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        IFile file = root.getFile(location);
        if (file.exists()) {
            logger.warn(String.format(THE_FILE_ALREADY_EXISTS_SKIPPED_GENERATION_OF, location));
        } else {
            IContainer parentContainer;
            if (!file.getParent().exists() && (parentContainer = file.getParent()) instanceof IFolder) {
                ((IFolder)parentContainer).create(false, true, null);
            }
            file.create((InputStream)new ByteArrayInputStream(bytes), false, null);
            this.createdFiles.add(file);
        }
        IContainer parent = file.getParent();
        if (parent != null) {
            WorkspaceViewerUtils.expandElement((Object)parent);
        }
        WorkspaceViewerUtils.selectElement((Object)file);
    }

    protected void copyFile(String targetFileName, String templateLocation, Class<?> clazz) throws IOException, Exception {
        IPath location = new Path(this.getModel().getTargetLocation()).append(targetFileName);
        InputStream in = clazz.getResourceAsStream(templateLocation);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        IOUtils.copy((InputStream)in, (OutputStream)out);
        this.createFile(location, out.toByteArray());
    }

    public List<IFile> getGeneratedFiles() {
        return this.createdFiles;
    }

    public VelocityGenerator getVelocityGenerator() {
        return this.velocityGenerator;
    }
}

