/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.repository.api;

import java.util.Arrays;
import java.util.StringTokenizer;

public class RepositoryPath {
    private String path;
    private final String[] segments;

    public RepositoryPath(String path) {
        this.path = path;
        StringTokenizer tokenizer = new StringTokenizer(path, "/");
        this.segments = new String[tokenizer.countTokens()];
        int i = 0;
        while (i < this.segments.length) {
            this.segments[i] = tokenizer.nextToken();
            ++i;
        }
    }

    public RepositoryPath(RepositoryPath repositoryPath) {
        this(repositoryPath.segments);
    }

    public RepositoryPath(String[] segments) {
        this.segments = Arrays.copyOf(segments, segments.length);
        this.path = this.toString();
    }

    public String getLastSegment() {
        if (this.segments.length == 0) {
            return "";
        }
        return this.segments[this.segments.length - 1];
    }

    public RepositoryPath getParentPath() {
        if (this.segments.length == 0) {
            return null;
        }
        String[] newSegments = Arrays.copyOf(this.segments, this.segments.length - 1);
        return new RepositoryPath(newSegments);
    }

    public RepositoryPath append(String name) {
        String[] newSegments = Arrays.copyOf(this.segments, this.segments.length + 1);
        newSegments[newSegments.length - 1] = name;
        return new RepositoryPath(newSegments);
    }

    public String toString() {
        if (this.segments.length == 0) {
            return "/";
        }
        StringBuilder builder = new StringBuilder();
        String[] stringArray = this.segments;
        int n = this.segments.length;
        int n2 = 0;
        while (n2 < n) {
            String segment = stringArray[n2];
            builder.append("/");
            builder.append(segment);
            ++n2;
        }
        return builder.toString();
    }

    public String getPath() {
        return this.path;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof RepositoryPath)) {
            return false;
        }
        RepositoryPath other = (RepositoryPath)obj;
        return this.getPath().equals(other.getPath());
    }

    public int hashCode() {
        return this.getPath().hashCode();
    }

    public String[] getSegments() {
        return Arrays.copyOf(this.segments, this.segments.length);
    }

    public String constructPath(int number) {
        if (number >= this.segments.length) {
            return this.toString();
        }
        if (this.segments.length == 0) {
            return "/";
        }
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < number) {
            builder.append("/");
            builder.append(this.segments[i]);
            ++i;
        }
        return builder.toString();
    }

    public static String normalizePath(String path, String name) {
        String normalizedPath = null;
        if (path != null) {
            normalizedPath = path.endsWith("/") ? String.valueOf(path) + name : String.valueOf(path) + "/" + name;
        }
        return normalizedPath;
    }
}

