/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.runtime.content;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.dirigible.repository.ext.db.transfer.DBTableExporter;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.dirigible.runtime.PermissionsUtils;
import org.eclipse.dirigible.runtime.content.ContentBaseServlet;
import org.eclipse.dirigible.runtime.repository.RepositoryFacade;

public class DataExporterServlet
extends ContentBaseServlet {
    private static final String PARAMETER_TABLE = "table";
    private static final long serialVersionUID = 5798183051027211544L;
    private static final Logger logger = Logger.getLogger(DataExporterServlet.class);
    private static final String GUID = "guid";
    private static final String EMPTY = "";
    private static final String DATE_FORMAT = "yyyyMMdd-HHmmss";
    static final String UNKNOWN_HOST = "unknown_host";
    static final String UNDERSCORE = "_";
    public static final String PARAMETER_TABLE_ERR = "Parameter 'table' is not present. Use .../data-export?table=TABLE_XXX";

    protected String getExportFilePrefix(String tableName) {
        StringBuilder buff = new StringBuilder();
        buff.append(tableName).append(UNDERSCORE);
        try {
            buff.append(InetAddress.getLocalHost().getHostName());
        }
        catch (UnknownHostException e) {
            logger.error(e.getMessage(), (Throwable)e);
            buff.append(UNKNOWN_HOST);
        }
        return buff.toString();
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (!PermissionsUtils.isUserInRole((HttpServletRequest)request, (String)"Operator")) {
            String err = String.format("%s called, but the user does not have permissions to do this operation", "Data Export");
            logger.error(err);
            throw new ServletException(err);
        }
        String tableName = request.getParameter(PARAMETER_TABLE);
        if (tableName == null || EMPTY.equals(tableName)) {
            logger.error(PARAMETER_TABLE_ERR);
            throw new ServletException(PARAMETER_TABLE_ERR);
        }
        request.getSession().setAttribute(GUID, (Object)this.createGUID());
        try {
            byte[] data = this.getData(tableName, request);
            this.send(tableName, request, response, data);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            response.sendError(500, e.getMessage());
        }
    }

    private byte[] getData(String tableName, HttpServletRequest request) {
        DBTableExporter dbTableExporter = new DBTableExporter(RepositoryFacade.getInstance().getDataSource());
        dbTableExporter.setTableName(tableName);
        byte[] data = dbTableExporter.getTableData().getBytes();
        return data;
    }

    private void send(String tableName, HttpServletRequest request, HttpServletResponse response, byte[] content) throws IOException {
        int len;
        String fileName = null;
        fileName = String.valueOf(this.defaultFileName(tableName, request)) + ".dsv";
        response.setContentType("application/zip");
        response.setHeader("Content-Disposition", "attachment;filename=\"" + fileName + "\"");
        BufferedOutputStream bos = new BufferedOutputStream((OutputStream)response.getOutputStream());
        ByteArrayInputStream fis = new ByteArrayInputStream(content);
        byte[] buf = new byte[1024];
        while ((len = fis.read(buf)) > 0) {
            bos.write(buf, 0, len);
        }
        bos.close();
        fis.close();
    }

    private String defaultFileName(String tableName, HttpServletRequest request) {
        String guid = EMPTY.equals(this.getGUID(request)) ? EMPTY : this.getGUID(request);
        String fileName = String.valueOf(this.getExportFilePrefix(tableName)) + UNDERSCORE + guid;
        return fileName;
    }

    private String createGUID() {
        SimpleDateFormat sdfDate = new SimpleDateFormat(DATE_FORMAT);
        Date now = new Date();
        String strDate = sdfDate.format(now);
        return strDate;
    }

    private String getGUID(HttpServletRequest request) {
        return (String)request.getSession().getAttribute(GUID);
    }
}

