/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.runtime.flow;

import com.google.gson.Gson;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.dirigible.repository.api.IRepository;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.dirigible.runtime.flow.Flow;
import org.eclipse.dirigible.runtime.flow.FlowCase;
import org.eclipse.dirigible.runtime.flow.FlowStep;
import org.eclipse.dirigible.runtime.scripting.AbstractScriptExecutor;
import org.eclipse.dirigible.runtime.scripting.IScriptExecutor;
import org.eclipse.dirigible.runtime.scripting.utils.EngineUtils;

public class FlowExecutor
extends AbstractScriptExecutor {
    private static final String CONDITION_PARAMETER_ANY = "any";
    private static final String CONDITION_PARAMETER_NULL = "null";
    private static final Logger logger = Logger.getLogger(FlowExecutor.class);
    private IRepository repository;
    private String[] rootPaths;
    private Gson gson = new Gson();

    public FlowExecutor(IRepository repository, String ... rootPaths) {
        logger.debug("entering: constructor()");
        this.repository = repository;
        this.rootPaths = rootPaths;
        if (this.rootPaths == null || this.rootPaths.length == 0) {
            this.rootPaths = new String[2];
        }
        logger.debug("exiting: constructor()");
    }

    public Object executeServiceModule(HttpServletRequest request, HttpServletResponse response, Object input, String module, Map<Object, Object> executionContext) throws IOException {
        logger.debug("entering: executeServiceModule()");
        logger.debug("module=" + module);
        if (module == null) {
            throw new IOException("Flow module cannot be null");
        }
        String result = null;
        String flowSource = new String(this.retrieveModule(this.repository, module, "", this.rootPaths).getContent());
        Flow flow = (Flow)this.gson.fromJson(flowSource, Flow.class);
        Object inputOutput = null;
        result = (inputOutput = this.processFlow(request, response, module, executionContext, flow, inputOutput)) != null ? inputOutput.toString() : "";
        logger.debug("exiting: executeServiceModule()");
        return result;
    }

    private Object processFlow(HttpServletRequest request, HttpServletResponse response, String module, Map<Object, Object> executionContext, Flow flow, Object inputOutput) throws IOException {
        executionContext.putAll(flow.getProperties());
        FlowStep[] flowStepArray = flow.getSteps();
        int n = flowStepArray.length;
        int n2 = 0;
        while (n2 < n) {
            FlowStep flowStep = flowStepArray[n2];
            try {
                inputOutput = this.executeByEngineType(request, response, module, executionContext, flow, inputOutput, flowStep);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                response.sendError(500, e.getMessage());
            }
            ++n2;
        }
        return inputOutput;
    }

    private Object executeByEngineType(HttpServletRequest request, HttpServletResponse response, String module, Map<Object, Object> executionContext, Flow flow, Object inputOutput, FlowStep flowStep) throws IOException {
        if ("condition".equalsIgnoreCase(flowStep.getType())) {
            FlowCase[] cases;
            FlowCase[] flowCaseArray = cases = flowStep.getCases();
            int n = cases.length;
            int n2 = 0;
            while (n2 < n) {
                FlowCase flowCase = flowCaseArray[n2];
                Object value = executionContext.get(flowCase.getKey());
                if (value == null && request != null) {
                    value = request.getParameter(flowCase.getKey());
                }
                if (value != null && value.equals(flowCase.getValue()) || flowCase.getValue() != null && flowCase.getValue().equalsIgnoreCase(CONDITION_PARAMETER_NULL) && value == null || flowCase.getValue() != null && flowCase.getValue().equalsIgnoreCase(CONDITION_PARAMETER_ANY) && value != null) {
                    this.processFlow(request, response, module, executionContext, flowCase.getFlow(), inputOutput);
                    break;
                }
                ++n2;
            }
        } else if ("output".equalsIgnoreCase(flowStep.getType())) {
            if (response != null) {
                response.getWriter().print(flowStep.getMessage());
            } else {
                System.out.println(flowStep.getMessage());
            }
        } else {
            Set types = EngineUtils.getTypes();
            for (String type : types) {
                if (type == null || !type.equalsIgnoreCase(flowStep.getType())) continue;
                IScriptExecutor scriptExecutor = EngineUtils.createExecutor((String)type, (HttpServletRequest)request);
                scriptExecutor.executeServiceModule(request, response, flowStep.getModule(), executionContext);
                break;
            }
        }
        return inputOutput;
    }

    protected void registerDefaultVariable(Object scope, String name, Object value) {
    }

    protected String getModuleType(String path) {
        return "IntegrationServices";
    }
}

