/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.runtime.listener;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.sql.DataSource;
import org.eclipse.dirigible.repository.api.ICollection;
import org.eclipse.dirigible.repository.api.IRepository;
import org.eclipse.dirigible.repository.api.IResource;
import org.eclipse.dirigible.repository.ext.db.AbstractDataUpdater;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.dirigible.runtime.listener.IListenerEventProcessor;
import org.eclipse.dirigible.runtime.listener.Listener;
import org.eclipse.dirigible.runtime.listener.ListenerEventProcessorFactory;
import org.eclipse.dirigible.runtime.listener.ListenerParser;
import org.eclipse.dirigible.runtime.listener.ListenersException;

public class ListenersUpdater
extends AbstractDataUpdater {
    public static final String EXTENSION_LISTENER = ".listener";
    public static final String REGISTRY_INTEGRATION_DEFAULT = "/db/dirigible/registry/public/IntegrationServices";
    private static final Logger logger = Logger.getLogger(ListenersUpdater.class);
    private IRepository repository;
    private DataSource dataSource;
    private String location;
    public static List<IListenerEventProcessor> activeListeners = Collections.synchronizedList(new ArrayList());

    public ListenersUpdater(IRepository repository, DataSource dataSource, String location) throws ListenersException {
        this.repository = repository;
        this.dataSource = dataSource;
        this.location = location;
    }

    public void executeUpdate(List<String> knownFiles, HttpServletRequest request, List<String> errors) throws Exception {
        if (knownFiles.size() == 0) {
            return;
        }
        try {
            Connection connection = this.dataSource.getConnection();
            try {
                for (IListenerEventProcessor activeListener : activeListeners) {
                    activeListener.stop();
                }
                activeListeners.clear();
                for (String listenerDefinition : knownFiles) {
                    try {
                        if (!listenerDefinition.endsWith(EXTENSION_LISTENER)) continue;
                        this.executeListenerUpdate(connection, listenerDefinition, request);
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage(), (Throwable)e);
                        errors.add(e.getMessage());
                    }
                }
            }
            finally {
                if (connection != null) {
                    connection.close();
                }
            }
        }
        catch (SQLException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private void executeListenerUpdate(Connection connection, String listenerDefinition, HttpServletRequest request) throws IOException {
        String resourcePath = listenerDefinition;
        IResource resource = this.repository.getResource(resourcePath);
        String content = new String(resource.getContent());
        Listener listener = ListenerParser.parseListener(content);
        IListenerEventProcessor processor = ListenerEventProcessorFactory.createListenerEventProcessor(listener.getTrigger());
        processor.start(listener);
        activeListeners.add(processor);
    }

    public void enumerateKnownFiles(ICollection collection, List<String> dsDefinitions) throws IOException {
        if (collection.exists()) {
            List resources = collection.getResources();
            for (IResource resource : resources) {
                if (resource == null || resource.getName() == null || !resource.getName().endsWith(EXTENSION_LISTENER)) continue;
                String fullPath = resource.getPath();
                dsDefinitions.add(fullPath);
            }
            List collections = collection.getCollections();
            for (ICollection subCollection : collections) {
                this.enumerateKnownFiles(subCollection, dsDefinitions);
            }
        }
    }

    public void applyUpdates() throws IOException, Exception {
        ArrayList<String> knownFiles = new ArrayList<String>();
        ICollection srcContainer = this.repository.getCollection(this.location);
        if (srcContainer.exists()) {
            this.enumerateKnownFiles(srcContainer, knownFiles);
            this.executeUpdate(knownFiles, null);
        }
    }

    public IRepository getRepository() {
        return this.repository;
    }

    public String getLocation() {
        return this.location;
    }

    public void executeUpdate(List<String> knownFiles, List<String> errors) throws Exception {
        this.executeUpdate(knownFiles, null, errors);
    }
}

