/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.jdbc.ConnectionContext;
import org.apache.derby.iapi.services.loader.GeneratedMethod;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.impl.sql.execute.NoRowsResultSetImpl;

class CallStatementResultSet
extends NoRowsResultSetImpl {
    private final GeneratedMethod methodCall;

    CallStatementResultSet(GeneratedMethod generatedMethod, Activation activation) {
        super(activation);
        this.methodCall = generatedMethod;
    }

    public void open() throws StandardException {
        this.setup();
        this.methodCall.invoke(this.activation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() throws StandardException {
        super.close();
        ResultSet[][] resultSetArray = this.getActivation().getDynamicResults();
        if (resultSetArray != null) {
            StandardException standardException = null;
            ConnectionContext connectionContext = null;
            for (int i = 0; i < resultSetArray.length; ++i) {
                Object var10_9;
                ResultSet[] resultSetArray2 = resultSetArray[i];
                ResultSet resultSet = resultSetArray2[0];
                if (resultSet == null) continue;
                if (connectionContext == null) {
                    connectionContext = (ConnectionContext)((Object)this.lcc.getContextManager().getContext("JDBC_ConnectionContext"));
                }
                try {
                    try {
                        if (!connectionContext.processInaccessibleDynamicResult(resultSet)) {
                            var10_9 = null;
                            resultSetArray2[0] = null;
                            continue;
                        }
                        resultSet.close();
                    }
                    catch (SQLException sQLException) {
                        if (standardException == null) {
                            StandardException standardException2;
                            standardException = standardException2 = StandardException.plainWrapException(sQLException);
                        }
                        var10_9 = null;
                        resultSetArray2[0] = null;
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    var10_9 = null;
                    resultSetArray2[0] = null;
                    throw throwable;
                }
                var10_9 = null;
                resultSetArray2[0] = null;
            }
            if (standardException != null) {
                throw standardException;
            }
        }
    }

    public void cleanUp() throws StandardException {
        this.close();
    }
}

