/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.diagram.edit.policies;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecoretools.diagram.expressions.EcoreAbstractExpression;
import org.eclipse.emf.ecoretools.diagram.expressions.EcoreOCLFactory;
import org.eclipse.emf.ecoretools.diagram.part.EcoreDiagramEditorPlugin;
import org.eclipse.emf.ecoretools.diagram.part.EcoreVisualIDRegistry;
import org.eclipse.emf.ecoretools.diagram.providers.EcoreElementTypes;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.requests.ReconnectRequest;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.commands.DeleteCommand;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.commands.CommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.SemanticEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.requests.EditCommandRequestWrapper;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyReferenceRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DuplicateElementsRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.GetEditContextRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.MoveRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientReferenceRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.View;

public class EcoreBaseItemSemanticEditPolicy
extends SemanticEditPolicy {
    public static final String VISUAL_ID_KEY = "visual_id";
    private final IElementType myElementType;

    protected EcoreBaseItemSemanticEditPolicy(IElementType elementType) {
        this.myElementType = elementType;
    }

    public Command getCommand(Request request) {
        Object view;
        if (request instanceof ReconnectRequest && (view = ((ReconnectRequest)request).getConnectionEditPart().getModel()) instanceof View) {
            Integer id = new Integer(EcoreVisualIDRegistry.getVisualID((View)view));
            request.getExtendedData().put(VISUAL_ID_KEY, id);
        }
        return super.getCommand(request);
    }

    protected int getVisualID(IEditCommandRequest request) {
        Object id = request.getParameter(VISUAL_ID_KEY);
        return id instanceof Integer ? (Integer)id : -1;
    }

    protected Command getSemanticCommand(IEditCommandRequest request) {
        IEditCommandRequest completedRequest = this.completeRequest(request);
        Command semanticCommand = this.getSemanticCommandSwitch(completedRequest);
        semanticCommand = this.getEditHelperCommand(completedRequest, semanticCommand);
        if (completedRequest instanceof DestroyRequest) {
            DestroyRequest destroyRequest = (DestroyRequest)completedRequest;
            return this.shouldProceed(destroyRequest) ? this.addDeleteViewCommand(semanticCommand, destroyRequest) : null;
        }
        return semanticCommand;
    }

    protected Command addDeleteViewCommand(Command mainCommand, DestroyRequest completedRequest) {
        TransactionalEditingDomain editingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
        Command deleteViewCommand = this.getGEFWrapper((ICommand)new DeleteCommand(editingDomain, (View)this.getHost().getModel()));
        return mainCommand == null ? deleteViewCommand : mainCommand.chain(deleteViewCommand);
    }

    private Command getEditHelperCommand(IEditCommandRequest request, Command editPolicyCommand) {
        if (editPolicyCommand != null) {
            CommandProxy command = editPolicyCommand instanceof ICommandProxy ? ((ICommandProxy)editPolicyCommand).getICommand() : new CommandProxy(editPolicyCommand);
            request.setParameter("edit policy command", (Object)command);
        }
        IElementType requestContextElementType = this.getContextElementType(request);
        request.setParameter("context element type", (Object)requestContextElementType);
        ICommand command = requestContextElementType.getEditCommand(request);
        request.setParameter("edit policy command", null);
        request.setParameter("context element type", null);
        if (command != null) {
            if (!(command instanceof CompositeTransactionalCommand)) {
                TransactionalEditingDomain editingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
                command = new CompositeTransactionalCommand(editingDomain, command.getLabel()).compose((IUndoableOperation)command);
            }
            return new ICommandProxy(command);
        }
        return editPolicyCommand;
    }

    private IElementType getContextElementType(IEditCommandRequest request) {
        IElementType requestContextElementType = EcoreElementTypes.getElementType(this.getVisualID(request));
        return requestContextElementType != null ? requestContextElementType : this.myElementType;
    }

    protected Command getSemanticCommandSwitch(IEditCommandRequest req) {
        if (req instanceof CreateRelationshipRequest) {
            return this.getCreateRelationshipCommand((CreateRelationshipRequest)req);
        }
        if (req instanceof CreateElementRequest) {
            return this.getCreateCommand((CreateElementRequest)req);
        }
        if (req instanceof ConfigureRequest) {
            return this.getConfigureCommand((ConfigureRequest)req);
        }
        if (req instanceof DestroyElementRequest) {
            return this.getDestroyElementCommand((DestroyElementRequest)req);
        }
        if (req instanceof DestroyReferenceRequest) {
            return this.getDestroyReferenceCommand((DestroyReferenceRequest)req);
        }
        if (req instanceof DuplicateElementsRequest) {
            return this.getDuplicateCommand((DuplicateElementsRequest)req);
        }
        if (req instanceof GetEditContextRequest) {
            return this.getEditContextCommand((GetEditContextRequest)req);
        }
        if (req instanceof MoveRequest) {
            return this.getMoveCommand((MoveRequest)req);
        }
        if (req instanceof ReorientReferenceRelationshipRequest) {
            return this.getReorientReferenceRelationshipCommand((ReorientReferenceRelationshipRequest)req);
        }
        if (req instanceof ReorientRelationshipRequest) {
            return this.getReorientRelationshipCommand((ReorientRelationshipRequest)req);
        }
        if (req instanceof SetRequest) {
            return this.getSetCommand((SetRequest)req);
        }
        return null;
    }

    protected Command getConfigureCommand(ConfigureRequest req) {
        return null;
    }

    protected Command getCreateRelationshipCommand(CreateRelationshipRequest req) {
        return null;
    }

    protected Command getCreateCommand(CreateElementRequest req) {
        return null;
    }

    protected Command getSetCommand(SetRequest req) {
        return null;
    }

    protected Command getEditContextCommand(GetEditContextRequest req) {
        return null;
    }

    protected Command getDestroyElementCommand(DestroyElementRequest req) {
        return null;
    }

    protected Command getDestroyReferenceCommand(DestroyReferenceRequest req) {
        return null;
    }

    protected Command getDuplicateCommand(DuplicateElementsRequest req) {
        return null;
    }

    protected Command getMoveCommand(MoveRequest req) {
        return null;
    }

    protected Command getReorientReferenceRelationshipCommand(ReorientReferenceRelationshipRequest req) {
        return UnexecutableCommand.INSTANCE;
    }

    protected Command getReorientRelationshipCommand(ReorientRelationshipRequest req) {
        return UnexecutableCommand.INSTANCE;
    }

    protected final Command getGEFWrapper(ICommand cmd) {
        return new ICommandProxy(cmd);
    }

    protected final Command getMSLWrapper(ICommand cmd) {
        return this.getGEFWrapper(cmd);
    }

    protected EObject getSemanticElement() {
        return ViewUtil.resolveSemanticElement((View)((View)this.getHost().getModel()));
    }

    protected TransactionalEditingDomain getEditingDomain() {
        return ((IGraphicalEditPart)this.getHost()).getEditingDomain();
    }

    protected Command getDestroyElementCommand(View view) {
        EditPart editPart = (EditPart)this.getHost().getViewer().getEditPartRegistry().get(view);
        DestroyElementRequest request = new DestroyElementRequest(this.getEditingDomain(), false);
        return editPart != null ? editPart.getCommand((Request)new EditCommandRequestWrapper((IEditCommandRequest)request, Collections.EMPTY_MAP)) : null;
    }

    protected CompoundCommand getDestroyEdgesCommand() {
        CompoundCommand cmd = new CompoundCommand();
        View view = (View)this.getHost().getModel();
        Iterator it = view.getSourceEdges().iterator();
        while (it.hasNext()) {
            cmd.add(this.getDestroyElementCommand((View)((Edge)it.next())));
        }
        it = view.getTargetEdges().iterator();
        while (it.hasNext()) {
            cmd.add(this.getDestroyElementCommand((View)((Edge)it.next())));
        }
        return cmd;
    }

    protected void addDestroyShortcutsCommand(CompoundCommand command) {
        View view = (View)this.getHost().getModel();
        if (view.getEAnnotation("Shortcut") != null) {
            return;
        }
        for (View nextView : view.getDiagram().getChildren()) {
            if (nextView.getEAnnotation("Shortcut") == null || !nextView.isSetElement() || nextView.getElement() != view.getElement()) continue;
            command.add(this.getDestroyElementCommand(nextView));
        }
    }

    public static class LinkConstraints {
        private static final String OPPOSITE_END_VAR = "oppositeEnd";
        private static EcoreAbstractExpression EReference_3002_TargetExpression;
        private static EcoreAbstractExpression EClassESuperTypes_3003_TargetExpression;

        public static boolean canCreateEAnnotationReferences_3001(EAnnotation source, EObject target) {
            if (source != null && source.getReferences().contains((Object)target)) {
                return false;
            }
            return LinkConstraints.canExistEAnnotationReferences_3001(source, target);
        }

        public static boolean canCreateEReference_3002(EClass source, EClassifier target) {
            return LinkConstraints.canExistEReference_3002(source, target);
        }

        public static boolean canCreateEClassESuperTypes_3003(EClass source, EClass target) {
            if (source != null && source.getESuperTypes().contains((Object)target)) {
                return false;
            }
            return LinkConstraints.canExistEClassESuperTypes_3003(source, target);
        }

        public static boolean canExistEAnnotationReferences_3001(EAnnotation source, EObject target) {
            return true;
        }

        public static boolean canExistEReference_3002(EClass source, EClassifier target) {
            Object targetVal;
            block4: {
                try {
                    if (target != null) break block4;
                    return true;
                }
                catch (Exception e) {
                    EcoreDiagramEditorPlugin.getInstance().logError("Link constraint evaluation error", e);
                    return false;
                }
            }
            if (EReference_3002_TargetExpression == null) {
                Map<String, EClass> env = Collections.singletonMap(OPPOSITE_END_VAR, EcorePackage.eINSTANCE.getEClass());
                EReference_3002_TargetExpression = EcoreOCLFactory.getExpression("self.oclIsKindOf(ecore::EClass)", (EClassifier)EcorePackage.eINSTANCE.getEClassifier(), env);
            }
            return (targetVal = EReference_3002_TargetExpression.evaluate(target, Collections.singletonMap(OPPOSITE_END_VAR, source))) instanceof Boolean && (Boolean)targetVal != false;
        }

        public static boolean canExistEClassESuperTypes_3003(EClass source, EClass target) {
            Object targetVal;
            block4: {
                try {
                    if (target != null) break block4;
                    return true;
                }
                catch (Exception e) {
                    EcoreDiagramEditorPlugin.getInstance().logError("Link constraint evaluation error", e);
                    return false;
                }
            }
            if (EClassESuperTypes_3003_TargetExpression == null) {
                Map<String, EClass> env = Collections.singletonMap(OPPOSITE_END_VAR, EcorePackage.eINSTANCE.getEClass());
                EClassESuperTypes_3003_TargetExpression = EcoreOCLFactory.getExpression("self <> oppositeEnd and not oppositeEnd.eSuperTypes->includes(self) and not self.eAllSuperTypes->includes(oppositeEnd)", (EClassifier)EcorePackage.eINSTANCE.getEClass(), env);
            }
            return (targetVal = EClassESuperTypes_3003_TargetExpression.evaluate(target, Collections.singletonMap(OPPOSITE_END_VAR, source))) instanceof Boolean && (Boolean)targetVal != false;
        }
    }
}

