/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.tabbedproperties.sections;

import java.util.regex.Pattern;
import org.eclipse.emf.ecoretools.tabbedproperties.internal.Messages;
import org.eclipse.emf.ecoretools.tabbedproperties.internal.utils.ColorRegistry;
import org.eclipse.emf.ecoretools.tabbedproperties.sections.AbstractTextPropertySection;
import org.eclipse.swt.widgets.Event;

public abstract class AbstractDoublePropertySection
extends AbstractTextPropertySection {
    public static final String EXP_NUMERIC_PATTERN = "^[-\\d][\\d]*\\.?[\\d]*((e|E)?-?[\\d]*)";
    public static final Pattern DOUBLE_PATTERN = Pattern.compile("^[-\\d][\\d]*\\.?[\\d]*((e|E)?-?[\\d]*)");

    @Override
    protected void verifyField(Event e) {
        String value = this.getText().getText();
        if (value == null || value.equals("") || this.isTextValid()) {
            this.setErrorMessage(null);
            this.getText().setBackground(null);
            e.doit = true;
        } else {
            this.setErrorMessage(Messages.AbstractDoublePropertySection_NotValid);
            this.getText().setBackground(ColorRegistry.COLOR_ERROR);
            e.doit = false;
        }
    }

    @Override
    protected String getFeatureAsString() {
        return this.getFeatureDouble().toString();
    }

    @Override
    protected Object getOldFeatureValue() {
        return this.getFeatureDouble();
    }

    @Override
    protected Object getNewFeatureValue(String newText) {
        if (newText == null || newText.equals("")) {
            return null;
        }
        return new Double(Double.parseDouble(newText));
    }

    protected abstract Double getFeatureDouble();

    @Override
    protected boolean isTextValid() {
        return DOUBLE_PATTERN.matcher(this.getText().getText()).matches();
    }
}

