/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.internal.views;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.provider.EcoreItemProviderAdapterFactory;
import org.eclipse.emf.ecoretools.internal.Messages;
import org.eclipse.emf.ecoretools.internal.views.AnalysisView;
import org.eclipse.emf.ecoretools.internal.views.EClassDescendentHierarchyContentProvider;
import org.eclipse.emf.ecoretools.internal.views.EClassHierarchyContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.progress.WorkbenchJob;

public class EClassHierarchyView
extends AnalysisView {
    public static final String VIEW_ID = "org.eclipse.emf.ecoretools.internal.views.EClassHierarchyView";
    private static final int ASCENDANT = 0;
    private static final int DESCENDANT = 1;
    private TreeViewer hierarchyTree;
    private int kind = 0;
    private Job refreshJob;

    @Override
    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.hierarchyTree = new TreeViewer(parent, 772);
        this.hierarchyTree.getControl().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (EClassHierarchyView.this.refreshJob != null) {
                    EClassHierarchyView.this.refreshJob.cancel();
                }
            }
        });
        this.setKind(0);
    }

    private void setKind(int hierarchyKind) {
        this.kind = hierarchyKind;
        switch (this.kind) {
            case 0: {
                this.hierarchyTree.setContentProvider((IContentProvider)new EClassHierarchyContentProvider());
                this.hierarchyTree.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)new EcoreItemProviderAdapterFactory()));
                break;
            }
            case 1: {
                this.hierarchyTree.setContentProvider((IContentProvider)new EClassDescendentHierarchyContentProvider());
                this.hierarchyTree.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)new EcoreItemProviderAdapterFactory()));
                break;
            }
        }
        this.refresh();
    }

    @Override
    protected void refresh(EObject object) {
        if (this.refreshJob != null) {
            this.refreshJob.cancel();
        }
        if (object instanceof EClass) {
            EClass selectedEClass = (EClass)object;
            this.refreshJob = this.createRefreshJob(selectedEClass);
            this.refreshJob.schedule(200L);
        }
    }

    private Job createRefreshJob(final EClass selection) {
        WorkbenchJob job = new WorkbenchJob(Messages.EClassHierarchyView_RefreshHierarchy){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                if (EClassHierarchyView.this.hierarchyTree.getControl().isDisposed()) {
                    return Status.CANCEL_STATUS;
                }
                try {
                    EClassHierarchyView.this.hierarchyTree.getControl().setRedraw(false);
                    EClassHierarchyView.this.hierarchyTree.setInput((Object)new EClass[]{selection});
                    EClassHierarchyView.this.hierarchyTree.refresh();
                    switch (EClassHierarchyView.this.kind) {
                        case 0: {
                            EClassHierarchyView.this.hierarchyTree.expandAll();
                            break;
                        }
                        case 1: {
                            EClassHierarchyView.this.hierarchyTree.expandToLevel(2);
                            break;
                        }
                    }
                }
                finally {
                    EClassHierarchyView.this.hierarchyTree.getControl().setRedraw(true);
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        return job;
    }

    @Override
    protected void fillToolBar(IToolBarManager toolBar) {
        Action ascendantAction = new Action(Messages.EClassHierarchyView_Ascendant, 8){

            public void run() {
                EClassHierarchyView.this.setKind(0);
            }
        };
        ascendantAction.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.emf.ecoretools", (String)"icons/elcl16/super_co.gif"));
        ascendantAction.setChecked(true);
        Action descendantAction = new Action(Messages.EClassHierarchyView_Descendant, 8){

            public void run() {
                EClassHierarchyView.this.setKind(1);
            }
        };
        descendantAction.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.emf.ecoretools", (String)"icons/elcl16/sub_co.gif"));
        toolBar.add((IAction)ascendantAction);
        toolBar.add((IAction)descendantAction);
        super.fillToolBar(toolBar);
    }
}

