/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.tabbedproperties.sections;

import java.util.ArrayList;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.provider.EcoreItemProviderAdapterFactory;
import org.eclipse.emf.ecoretools.tabbedproperties.providers.TabbedPropertiesLabelProvider;
import org.eclipse.emf.ecoretools.tabbedproperties.sections.AbstractTabbedPropertySection;
import org.eclipse.emf.ecoretools.tabbedproperties.sections.widgets.CSingleObjectChooser;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public abstract class AbstractChooserPropertySection
extends AbstractTabbedPropertySection {
    private boolean isRefreshing = false;
    private CSingleObjectChooser cSingleObjectChooser;
    private CLabel labelCombo;

    @Override
    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
    }

    @Override
    protected void createWidgets(Composite composite) {
        this.labelCombo = this.getWidgetFactory().createCLabel(composite, this.getLabelText());
        this.cSingleObjectChooser = new CSingleObjectChooser(composite, this.getWidgetFactory(), 0);
        this.cSingleObjectChooser.setLabelProvider(this.getLabelProvider());
        this.cSingleObjectChooser.setSection(this);
        if (this.getFeature() != null) {
            this.cSingleObjectChooser.setChangeable(this.getFeature().isChangeable());
        }
    }

    @Override
    protected void setSectionData(Composite composite) {
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.cSingleObjectChooser, -5);
        data.top = new FormAttachment(0, 4);
        this.labelCombo.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment(0, this.getStandardLabelWidth(composite, new String[]{this.getLabelText()}));
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)this.labelCombo, 0, 0x1000000);
        this.cSingleObjectChooser.setLayoutData(data);
    }

    @Override
    protected void hookListeners() {
        this.cSingleObjectChooser.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractChooserPropertySection.this.handleComboModified();
            }
        });
    }

    protected void handleComboModified() {
        if (!this.isRefreshing && this.getFeatureValue() != this.cSingleObjectChooser.getSelection()) {
            EditingDomain editingDomain = this.getEditingDomain();
            if (this.getEObjectList().size() == 1) {
                editingDomain.getCommandStack().execute(SetCommand.create((EditingDomain)editingDomain, (Object)this.getEObject(), (Object)this.getFeature(), (Object)this.cSingleObjectChooser.getSelection()));
            } else {
                CompoundCommand compoundCommand = new CompoundCommand();
                for (EObject nextObject : this.getEObjectList()) {
                    compoundCommand.append(SetCommand.create((EditingDomain)editingDomain, (Object)nextObject, (Object)this.getFeature(), (Object)this.cSingleObjectChooser.getSelection()));
                }
                editingDomain.getCommandStack().execute((Command)compoundCommand);
            }
        }
    }

    public void refresh() {
        this.isRefreshing = true;
        this.cSingleObjectChooser.setChangeable(!this.isReadOnly());
        this.cSingleObjectChooser.setChoices(this.getComboFeatureValues());
        this.cSingleObjectChooser.setSelection(this.getFeatureValue());
        this.isRefreshing = false;
    }

    protected CSingleObjectChooser getCSingleObjectChooser() {
        return this.cSingleObjectChooser;
    }

    protected boolean isRefreshing() {
        return this.isRefreshing;
    }

    protected Object[] getChoices(EObject object, EClassifier type) {
        ArrayList<String> choices = new ArrayList<String>();
        choices.add("");
        choices.addAll(ItemPropertyDescriptor.getReachableObjectsOfType((EObject)this.getEObject(), (EClassifier)type));
        return choices.toArray();
    }

    protected String getItemLabelText(EObject object) {
        return object.toString();
    }

    protected ILabelProvider getLabelProvider() {
        return new TabbedPropertiesLabelProvider((AdapterFactory)new EcoreItemProviderAdapterFactory());
    }

    protected abstract Object getFeatureValue();

    protected abstract Object[] getComboFeatureValues();
}

