/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.tabbedproperties.sections;

import java.util.Iterator;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.provider.EcoreItemProviderAdapterFactory;
import org.eclipse.emf.ecoretools.tabbedproperties.internal.Messages;
import org.eclipse.emf.ecoretools.tabbedproperties.providers.TabbedPropertiesLabelProvider;
import org.eclipse.emf.ecoretools.tabbedproperties.sections.AbstractTabbedPropertySection;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public abstract class AbstractCollectionPropertySection
extends AbstractTabbedPropertySection {
    private Group groupMembers;
    private Composite compositeListElements;
    private Composite compositeButtons;
    private Composite compositeListMembers;
    private TableViewer listElements = null;
    private TableViewer listMembers = null;
    private Button buttonAdd = null;
    private Button buttonRemove = null;
    private Button buttonUp = null;
    private Button buttonDown = null;

    @Override
    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(parent, tabbedPropertySheetPage);
    }

    @Override
    protected void createWidgets(Composite composite) {
        this.groupMembers = this.getWidgetFactory().createGroup(composite, this.getLabelText());
        GridLayout gl = new GridLayout(3, false);
        this.groupMembers.setLayout((Layout)gl);
        this.compositeListElements = this.getWidgetFactory().createComposite((Composite)this.groupMembers);
        this.compositeListElements.setLayout((Layout)new GridLayout());
        this.compositeButtons = this.getWidgetFactory().createComposite((Composite)this.groupMembers);
        this.compositeButtons.setLayout((Layout)new GridLayout());
        this.compositeListMembers = this.getWidgetFactory().createComposite((Composite)this.groupMembers);
        this.compositeListMembers.setLayout((Layout)new GridLayout());
        this.listElements = new TableViewer(this.compositeListElements);
        this.listElements.setLabelProvider(this.getLabelProvider());
        this.listMembers = new TableViewer(this.compositeListMembers);
        this.listMembers.setLabelProvider(this.getLabelProvider());
        this.buttonAdd = this.getWidgetFactory().createButton(this.compositeButtons, Messages.AbstractCollectionPropertySection_Add, 8);
        this.buttonRemove = this.getWidgetFactory().createButton(this.compositeButtons, Messages.AbstractCollectionPropertySection_Remove, 8);
        this.getWidgetFactory().createLabel(this.compositeButtons, " ");
        this.buttonUp = this.getWidgetFactory().createButton(this.compositeButtons, Messages.AbstractCollectionPropertySection_Up, 8);
        this.buttonDown = this.getWidgetFactory().createButton(this.compositeButtons, Messages.AbstractCollectionPropertySection_Down, 8);
    }

    @Override
    protected void setSectionData(Composite composite) {
        FormData fdata = new FormData();
        fdata.top = new FormAttachment(0, 0);
        fdata.left = new FormAttachment(0, 0);
        fdata.right = new FormAttachment(100, 0);
        fdata.bottom = new FormAttachment(100, 0);
        this.groupMembers.setLayoutData((Object)fdata);
        GridData gdata = new GridData(1808);
        this.compositeListElements.setLayoutData((Object)gdata);
        gdata = new GridData();
        this.compositeButtons.setLayoutData((Object)gdata);
        gdata = new GridData(1808);
        this.compositeListMembers.setLayoutData((Object)gdata);
        gdata = new GridData(1808);
        this.listElements.getTable().setLayoutData((Object)gdata);
        this.listMembers.getTable().setLayoutData((Object)gdata);
        this.buttonAdd.setLayoutData((Object)gdata);
        this.buttonRemove.setLayoutData((Object)gdata);
        this.buttonUp.setLayoutData((Object)gdata);
        this.buttonDown.setLayoutData((Object)gdata);
    }

    @Override
    protected void hookListeners() {
        this.buttonAdd.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                AbstractCollectionPropertySection.this.handleAddButtonSelected();
            }
        });
        this.buttonRemove.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                AbstractCollectionPropertySection.this.handleRemoveButtonSelected();
            }
        });
        this.buttonUp.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                AbstractCollectionPropertySection.this.handleUpButtonSelected();
            }
        });
        this.buttonDown.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                AbstractCollectionPropertySection.this.handleDownButtonSelected();
            }
        });
    }

    protected IBaseLabelProvider getLabelProvider() {
        return new TabbedPropertiesLabelProvider((AdapterFactory)new EcoreItemProviderAdapterFactory());
    }

    public void refresh() {
        this.fillListElements();
        this.fillListMembers();
    }

    private void fillListElements() {
        EList<EObject> elements = this.getElements();
        this.listElements.getTable().removeAll();
        for (EObject object : elements) {
            this.listElements.add((Object)object);
        }
    }

    private void fillListMembers() {
        EList<EObject> elements = this.getFeatureAsList();
        this.listMembers.getTable().removeAll();
        for (EObject object : elements) {
            this.listMembers.add((Object)object);
        }
    }

    private void handleAddButtonSelected() {
        StructuredSelection selection;
        if (this.listElements.getSelection() instanceof StructuredSelection && !(selection = (StructuredSelection)this.listElements.getSelection()).isEmpty()) {
            Iterator iterator = selection.iterator();
            while (iterator.hasNext()) {
                this.executeAddCommand(iterator.next());
            }
        }
    }

    private void handleRemoveButtonSelected() {
        StructuredSelection selection;
        if (this.listMembers.getSelection() instanceof StructuredSelection && !(selection = (StructuredSelection)this.listMembers.getSelection()).isEmpty()) {
            Iterator iterator = selection.iterator();
            while (iterator.hasNext()) {
                this.executeRemoveCommand(iterator.next());
            }
        }
    }

    private void handleUpButtonSelected() {
        this.executeMovement(true);
    }

    private void handleDownButtonSelected() {
        this.executeMovement(false);
    }

    private void executeMovement(boolean up) {
        StructuredSelection selection;
        if (this.listMembers.getSelection() instanceof StructuredSelection && !(selection = (StructuredSelection)this.listMembers.getSelection()).isEmpty()) {
            BasicEList membersToMove = new BasicEList();
            Iterator iterator = selection.iterator();
            while (iterator.hasNext()) {
                membersToMove.add((Object)((EObject)iterator.next()));
            }
            int[] indexes = new int[membersToMove.size()];
            int k = 0;
            while (k < indexes.length) {
                indexes[k] = -1;
                ++k;
            }
            EList<EObject> members = this.getFeatureAsList();
            EList<EObject> movedMembers = this.moveMembers(members, (EList<EObject>)membersToMove, up, indexes);
            if (!movedMembers.equals(members)) {
                this.executeEmptyListCommand();
                this.executeAddAllCommand(movedMembers);
                this.listMembers.getTable().setSelection(indexes);
            }
        }
    }

    private EList<EObject> moveMembers(EList<EObject> members, EList<EObject> membersToMove, boolean up, int[] indexes) {
        BasicEList result = new BasicEList();
        if (this.firstOrLastElements(members, membersToMove, up, indexes)) {
            result.addAll(members);
        } else {
            EObject eobject;
            for (Object o : members) {
                EObject c;
                if (!(o instanceof EObject) || membersToMove.contains((Object)(c = (EObject)o))) continue;
                result.add((Object)c);
            }
            if (up) {
                int i = 0;
                while (i < membersToMove.size()) {
                    eobject = (EObject)membersToMove.get(i);
                    int index = members.indexOf((Object)eobject);
                    int newIndex = -1;
                    newIndex = index == 0 ? index : (!this.containsIndex(index - 1, indexes) ? index - 1 : index);
                    result.add(newIndex, (Object)eobject);
                    indexes[i] = newIndex;
                    ++i;
                }
            } else {
                int i = membersToMove.size() - 1;
                while (i >= 0) {
                    eobject = (EObject)membersToMove.get(i);
                    int index = members.indexOf((Object)eobject);
                    int newIndex = -1;
                    newIndex = index == members.size() - 1 ? members.size() - 1 : (!this.containsIndex(index + 1, indexes) ? index + 1 : index);
                    indexes[i] = newIndex;
                    --i;
                }
                i = 0;
                while (i < indexes.length) {
                    result.add(indexes[i], (Object)((EObject)membersToMove.get(i)));
                    ++i;
                }
            }
        }
        return result;
    }

    private boolean firstOrLastElements(EList<EObject> members, EList<EObject> membersToMove, boolean up, int[] indexes) {
        if (membersToMove.size() == members.size()) {
            return true;
        }
        int size = membersToMove.size();
        int[] indexes2 = new int[size];
        int i = 0;
        for (EObject member : membersToMove) {
            indexes2[i] = members.indexOf((Object)member);
            ++i;
        }
        if (indexes2[0] != 0 && up || indexes2[size - 1] != size - 1 && !up) {
            return false;
        }
        int j = 0;
        while (j < indexes2.length - 1) {
            if (indexes2[j + 1] - indexes2[j] != 1) {
                return false;
            }
            ++j;
        }
        if (indexes2[0] == 0 && !up || indexes2[size - 1] == size - 1 && up) {
            return false;
        }
        indexes = indexes2;
        return true;
    }

    private boolean containsIndex(int i, int[] indexes) {
        int j = 0;
        while (j < indexes.length) {
            if (indexes[j] == i) {
                return true;
            }
            ++j;
        }
        return false;
    }

    private void executeAddCommand(Object objectToAdd) {
        EditingDomain domain = this.getEditingDomain();
        if (domain != null) {
            Command command = AddCommand.create((EditingDomain)domain, (Object)this.getEObject(), (Object)this.getFeature(), (Object)objectToAdd);
            domain.getCommandStack().execute(command);
        }
    }

    private void executeRemoveCommand(Object objectToRemove) {
        EditingDomain domain = this.getEditingDomain();
        if (domain != null) {
            Command command = RemoveCommand.create((EditingDomain)domain, (Object)this.getEObject(), (Object)this.getFeature(), (Object)objectToRemove);
            domain.getCommandStack().execute(command);
        }
    }

    private void executeEmptyListCommand() {
        EditingDomain domain = this.getEditingDomain();
        if (domain != null) {
            Command command = SetCommand.create((EditingDomain)domain, (Object)this.getEObject(), (Object)this.getFeature(), (Object)new BasicEList());
            domain.getCommandStack().execute(command);
        }
    }

    private void executeAddAllCommand(EList<EObject> membersToAdd) {
        EditingDomain domain = this.getEditingDomain();
        if (domain != null) {
            Command command = SetCommand.create((EditingDomain)domain, (Object)this.getEObject(), (Object)this.getFeature(), membersToAdd);
            domain.getCommandStack().execute(command);
        }
    }

    protected EList<EObject> getFeatureAsList() {
        Object featureValue;
        EObject eobject = this.getEObject();
        if (eobject != null && (featureValue = eobject.eGet(this.getFeature())) instanceof EList) {
            return (EList)featureValue;
        }
        return null;
    }

    protected abstract EList<EObject> getElements();
}

