/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.tabbedproperties.sections;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecoretools.tabbedproperties.internal.sections.listeners.PropertiesAdapterImpl;
import org.eclipse.emf.ecoretools.tabbedproperties.internal.utils.MessageManager;
import org.eclipse.emf.ecoretools.tabbedproperties.utils.ObjectAdapter;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.PageBookView;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public abstract class AbstractTabbedPropertySection
extends AbstractPropertySection {
    private EObject eObject;
    private List<EObject> eObjectList;
    private IStatusLineManager statusLineManager;
    private MessageManager messageManager;
    private Composite sectionComposite;
    private Adapter modelListener = new PropertiesAdapterImpl(){

        @Override
        protected void safeNotifyChanged(Notification msg) {
            AbstractTabbedPropertySection.this.handleModelChanged(msg);
        }
    };

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        this.sectionComposite = this.getMainComposite(parent);
        this.createWidgets(this.sectionComposite);
        this.setSectionData(this.sectionComposite);
        this.hookListeners();
        this.messageManager = new MessageManager();
        IActionBars actionBars = aTabbedPropertySheetPage.getSite().getActionBars();
        this.makeContributions(actionBars.getMenuManager(), actionBars.getToolBarManager(), actionBars.getStatusLineManager());
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        Object ssel = ((IStructuredSelection)selection).getFirstElement();
        this.removeListener();
        this.eObject = this.adaptToEObject(ssel);
        this.eObjectList = new ArrayList<EObject>();
        Iterator iter = ((IStructuredSelection)selection).iterator();
        while (iter.hasNext()) {
            EObject element = this.adaptToEObject(iter.next());
            if (element == null) continue;
            this.eObjectList.add(element);
        }
        this.addListener();
    }

    protected EObject adaptToEObject(Object object) {
        return ObjectAdapter.adaptObject(object);
    }

    public void aboutToBeHidden() {
        this.removeListener();
    }

    public void aboutToBeShown() {
        this.addListener();
    }

    public void makeContributions(IMenuManager menuManager, IToolBarManager toolBarManager, IStatusLineManager statLineManager) {
        this.statusLineManager = statLineManager;
    }

    public IWorkbenchPage getActivePage() {
        IWorkbenchWindow window;
        IWorkbenchPage result = null;
        IWorkbench bench = PlatformUI.getWorkbench();
        if (bench != null && (window = bench.getActiveWorkbenchWindow()) != null) {
            result = window.getActivePage();
        }
        return result;
    }

    protected Composite getSectionComposite() {
        return this.sectionComposite;
    }

    protected Composite getMainComposite(Composite parent) {
        return this.getWidgetFactory().createFlatFormComposite(parent);
    }

    protected boolean isReadOnly() {
        Resource resource = this.getEObject().eResource();
        EditingDomain domain = this.getEditingDomain();
        return domain != null && resource != null && domain.isReadOnly(resource);
    }

    protected void setErrorMessage(String errorMessage) {
        if (this.statusLineManager != null) {
            this.statusLineManager.setErrorMessage(errorMessage);
        }
    }

    protected void setMessage(String message) {
        if (this.statusLineManager != null) {
            this.statusLineManager.setMessage(message);
        }
    }

    protected void removeListener() {
        if (this.getEObject() == null) {
            return;
        }
        if (this.getEObject().eAdapters().contains((Object)this.getModelListener())) {
            this.getEObject().eAdapters().remove((Object)this.getModelListener());
        }
    }

    protected void addListener() {
        if (this.getEObject() == null) {
            return;
        }
        if (!this.getEObject().eAdapters().contains((Object)this.getModelListener())) {
            this.getEObject().eAdapters().add((Object)this.getModelListener());
        }
    }

    protected int getStandardLabelWidth(Composite parent, String[] labels) {
        int standardLabelWidth = 150;
        GC gc = new GC((Drawable)parent);
        int indent = gc.textExtent((String)"XXX").x;
        int i = 0;
        while (i < labels.length) {
            int width = gc.textExtent((String)labels[i]).x;
            if (width + indent > standardLabelWidth) {
                standardLabelWidth = width + indent;
            }
            ++i;
        }
        gc.dispose();
        return standardLabelWidth;
    }

    protected EditingDomain getEditingDomain() {
        IPage page;
        IWorkbenchPart part = this.getPart();
        if (part.getAdapter(EditingDomain.class) != null) {
            return (EditingDomain)this.getPart().getAdapter(EditingDomain.class);
        }
        if (part instanceof IEditingDomainProvider) {
            return ((IEditingDomainProvider)part).getEditingDomain();
        }
        if (part.getAdapter(IEditingDomainProvider.class) != null) {
            return ((IEditingDomainProvider)part.getAdapter(IEditingDomainProvider.class)).getEditingDomain();
        }
        if (part instanceof PageBookView && (page = ((PageBookView)part).getCurrentPage()) instanceof IEditingDomainProvider) {
            return ((IEditingDomainProvider)page).getEditingDomain();
        }
        throw new IllegalArgumentException();
    }

    protected void createCommand(Object oldValue, Object newValue) {
        boolean equals;
        boolean bl = equals = oldValue == null ? false : oldValue.equals(newValue);
        if (!equals) {
            EditingDomain editingDomain = this.getEditingDomain();
            Object value = newValue;
            if (this.getEObjectList().size() == 1) {
                editingDomain.getCommandStack().execute(SetCommand.create((EditingDomain)editingDomain, (Object)this.getEObject(), (Object)this.getFeature(), (Object)value));
            } else {
                CompoundCommand compoundCommand = new CompoundCommand();
                for (EObject nextObject : this.getEObjectList()) {
                    compoundCommand.append(SetCommand.create((EditingDomain)editingDomain, (Object)nextObject, (Object)this.getFeature(), (Object)value));
                }
                editingDomain.getCommandStack().execute((Command)compoundCommand);
            }
        }
    }

    protected EObject getEObject() {
        return this.eObject;
    }

    protected List<EObject> getEObjectList() {
        return this.eObjectList;
    }

    protected IStatusLineManager getStatusLineManager() {
        return this.statusLineManager;
    }

    protected MessageManager getMessageManager() {
        return this.messageManager;
    }

    protected void setDecorator(Control control, String message, int type) {
        this.messageManager.addMessage("", message, null, type, control);
    }

    protected void setErrorDecorator(Control control, String message) {
        this.setDecorator(control, message, 3);
    }

    protected void setWarningDecorator(Control control, String message) {
        this.setDecorator(control, message, 2);
    }

    protected void setInfoDecorator(Control control, String message) {
        this.setDecorator(control, message, 1);
    }

    protected void clearDecorators() {
        this.messageManager.removeAllMessages();
    }

    protected Adapter getModelListener() {
        return this.modelListener;
    }

    protected void handleModelChanged(Notification msg) {
        Object notifier = msg.getNotifier();
        if (notifier.equals(this.getEObject()) && this.getFeature() != null && msg.getFeatureID(this.getEObject().getClass()) == this.getFeature().getFeatureID()) {
            this.refresh();
        }
    }

    protected abstract EStructuralFeature getFeature();

    protected abstract String getLabelText();

    protected void createWidgets(Composite composite) {
    }

    protected void setSectionData(Composite composite) {
    }

    protected void hookListeners() {
    }
}

