/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.tabbedproperties.sections;

import org.eclipse.emf.ecoretools.tabbedproperties.internal.Messages;
import org.eclipse.emf.ecoretools.tabbedproperties.sections.AbstractTabbedPropertySection;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FontDialog;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public abstract class AbstractFontPropertySection
extends AbstractTabbedPropertySection {
    private Text fontText;
    private CLabel fontLabel;
    private Button fontButton;

    protected void createWidgets(Composite composite) {
        this.fontLabel = this.getWidgetFactory().createCLabel(composite, this.getLabelText());
        this.fontText = this.getWidgetFactory().createText(composite, "");
        this.fontText.setEditable(false);
        this.fontButton = this.getWidgetFactory().createButton(composite, Messages.AbstractFontPropertySection_Change, 8);
    }

    protected void setSectionData(Composite composite) {
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.fontText, -5);
        data.top = new FormAttachment(0, 4);
        this.fontLabel.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment((Control)this.fontLabel, 5);
        data.right = new FormAttachment((Control)this.fontButton, -5);
        data.top = new FormAttachment(0, 4);
        this.fontText.setLayoutData((Object)data);
        data = new FormData();
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)this.fontLabel, 4, 0x1000000);
        this.fontButton.setLayoutData((Object)data);
    }

    protected void hookListeners() {
        this.fontButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                AbstractFontPropertySection.this.handleButtonPressed();
            }
        });
    }

    protected void handleButtonPressed() {
        FontDialog ftDialog = new FontDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        ftDialog.setFontList(this.getFontValue().getFontData());
        FontData fData = ftDialog.open();
        if (fData != null) {
            this.createCommand(this.getFontValue(), new Font(null, fData));
        }
    }

    public void refresh() {
        this.fontText.setText(StringConverter.asString((FontData[])this.getFontValue().getFontData()));
    }

    protected abstract Font getFontValue();
}

