/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.model.internal.fx;

import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import org.eclipse.emf.ecp.view.model.internal.fx.GridCellFX;
import org.eclipse.emf.ecp.view.model.internal.fx.GridDescriptionFX;
import org.eclipse.emf.ecp.view.model.internal.fx.GridDescriptionFXFactory;
import org.eclipse.emf.ecp.view.model.internal.fx.RendererFX;
import org.eclipse.emf.ecp.view.model.internal.fx.RendererFactory;
import org.eclipse.emf.ecp.view.spi.model.VContainedContainer;
import org.eclipse.emf.ecp.view.spi.model.VContainedElement;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.spi.renderer.NoPropertyDescriptorFoundExeption;
import org.eclipse.emf.ecp.view.spi.renderer.NoRendererFoundException;

public abstract class ContainerRendererFX<T extends VContainedContainer>
extends RendererFX<T> {
    private GridDescriptionFX gridDescription;

    protected abstract GridPane getGridPane();

    @Override
    public GridDescriptionFX getGridDescription() {
        if (this.gridDescription == null) {
            this.gridDescription = GridDescriptionFXFactory.INSTANCE.createSimpleGrid(1, 1, this);
        }
        return this.gridDescription;
    }

    protected GridPane renderGrid() throws NoRendererFoundException, NoPropertyDescriptorFoundExeption {
        GridPane grid = this.getGridPane();
        VContainedContainer element = (VContainedContainer)this.getVElement();
        int gridRow = -1;
        for (VContainedElement composite : element.getChildren()) {
            RendererFX<VElement> compositeRenderer = RendererFactory.INSTANCE.getRenderer((VElement)composite, this.getViewModelContext());
            GridDescriptionFX rendererGrid = compositeRenderer.getGridDescription();
            int rows = rendererGrid.getRows();
            int columns = rendererGrid.getColumns();
            int i = 0;
            while (i < rows) {
                ++gridRow;
                int j = 0;
                while (j < columns) {
                    Node node = compositeRenderer.render((GridCellFX)((Object)rendererGrid.getGrid().get(i * columns + j)));
                    grid.add(node, j, gridRow);
                    if (node instanceof Label) {
                        GridPane.setHgrow((Node)node, (Priority)Priority.SOMETIMES);
                    } else {
                        GridPane.setHgrow((Node)node, (Priority)Priority.ALWAYS);
                    }
                    if (VContainedContainer.class.isInstance(composite)) {
                        GridPane.setVgrow((Node)node, (Priority)Priority.ALWAYS);
                    }
                    ++j;
                }
                ++i;
            }
        }
        return grid;
    }
}

