/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.fx.internal.projects;

import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.TreeCell;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.util.Callback;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecp.util.e4.fx.ModelElementOpenerFX;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.emfstore.client.ESWorkspaceProvider;
import org.eclipse.emf.emfstore.fx.internal.projects.ESLocalProjectTreeCell;
import org.eclipse.emf.emfstore.fx.internal.projects.EmfStoreLocalTreeItem;

public class ProjectsView {
    ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);

    @Inject
    public ProjectsView() {
    }

    @PostConstruct
    public void postConstruct(BorderPane parent) {
        final TreeView localProjectsView = new TreeView();
        Button btnAddProject = new Button("Add LocalProject");
        btnAddProject.setMaxWidth(Double.MAX_VALUE);
        EmfStoreLocalTreeItem projectTreeItem = new EmfStoreLocalTreeItem(this, ESWorkspaceProvider.INSTANCE.getWorkspace(), (TreeView<Object>)localProjectsView);
        btnAddProject.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                ESWorkspaceProvider.INSTANCE.getWorkspace().createLocalProject("test");
            }
        });
        HBox box = new HBox();
        HBox.setHgrow((Node)btnAddProject, (Priority)Priority.ALWAYS);
        box.getChildren().add((Object)btnAddProject);
        localProjectsView.setRoot((TreeItem)projectTreeItem);
        localProjectsView.setShowRoot(false);
        localProjectsView.setCellFactory((Callback)new Callback<TreeView<Object>, TreeCell<Object>>(){

            public TreeCell<Object> call(TreeView<Object> param) {
                return new ESLocalProjectTreeCell(ProjectsView.this.adapterFactory);
            }
        });
        localProjectsView.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<TreeItem<Object>>(){

            public void changed(ObservableValue<? extends TreeItem<Object>> observable, TreeItem<Object> oldValue, TreeItem<Object> newValue) {
                TreeItem selectedItem;
                if (newValue != null && EObject.class.isInstance(newValue.getValue())) {
                    ModelElementOpenerFX.openModelElement((Object)newValue.getValue());
                }
                if ((selectedItem = (TreeItem)localProjectsView.getSelectionModel().getSelectedItem()) == null) {
                    return;
                }
            }
        });
        parent.setTop((Node)box);
        parent.setCenter((Node)localProjectsView);
    }
}

