/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.fx.internal.projects;

import java.util.ArrayList;
import java.util.List;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.control.MultipleSelectionModel;
import javafx.scene.control.SelectionModel;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.emfstore.client.ESLocalProject;
import org.eclipse.emf.emfstore.client.ESWorkspace;
import org.eclipse.emf.emfstore.client.ESWorkspaceProvider;
import org.eclipse.emf.emfstore.client.observer.ESCheckoutObserver;
import org.eclipse.emf.emfstore.common.ESObserver;
import org.eclipse.emf.emfstore.fx.internal.projects.ProjectsView;
import org.eclipse.emf.emfstore.internal.client.model.ESWorkspaceProviderImpl;
import org.eclipse.emf.emfstore.internal.client.model.ModelPackage;
import org.eclipse.emf.emfstore.internal.client.model.ProjectSpace;
import org.eclipse.emf.emfstore.internal.client.model.Workspace;
import org.eclipse.emf.emfstore.internal.client.model.impl.api.ESLocalProjectImpl;
import org.eclipse.emf.emfstore.internal.client.model.impl.api.ESWorkspaceImpl;
import org.eclipse.emf.emfstore.internal.common.model.IdEObjectCollection;
import org.eclipse.emf.emfstore.internal.common.model.util.IdEObjectCollectionChangeObserver;
import org.eclipse.fx.emf.edit.ui.AdapterFactoryTreeItem;

class EmfStoreLocalTreeItem
extends TreeItem<Object> {
    private final ProjectsView projectsView;
    private final ObservableList<TreeItem<Object>> children;
    private final TreeView<Object> view;

    public EmfStoreLocalTreeItem(ProjectsView projectsView, final ESWorkspace root, TreeView<Object> view) {
        super((Object)root);
        this.projectsView = projectsView;
        this.view = view;
        this.children = FXCollections.unmodifiableObservableList((ObservableList)super.getChildren());
        ((Workspace)((ESWorkspaceImpl)ESWorkspaceImpl.class.cast(root)).toInternalAPI()).eAdapters().add((Object)new AdapterImpl(){

            public void notifyChanged(Notification msg) {
                super.notifyChanged(msg);
                if (ModelPackage.eINSTANCE.getWorkspace_ProjectSpaces().equals(msg.getFeature())) {
                    EmfStoreLocalTreeItem.this.updatedWorkspace(root, EmfStoreLocalTreeItem.this.getExpandedItems(), EmfStoreLocalTreeItem.this.getSelectedItems(EmfStoreLocalTreeItem.this.getSelectionModel()), (SelectionModel)EmfStoreLocalTreeItem.this.getSelectionModel());
                }
            }
        });
        this.updatedWorkspace(root, this.getExpandedItems(), this.getSelectedItems(this.getSelectionModel()), (SelectionModel<?>)this.getSelectionModel());
    }

    public EmfStoreLocalTreeItem(ProjectsView projectsView, final ESLocalProject root, TreeView<Object> view) {
        super((Object)root);
        this.projectsView = projectsView;
        this.view = view;
        this.children = FXCollections.unmodifiableObservableList((ObservableList)super.getChildren());
        this.updateProject(root, this.getExpandedItems(), this.getSelectedItems(this.getSelectionModel()), this.getSelectionModel());
        ESWorkspaceProviderImpl.getObserverBus().register((ESObserver)new ESCheckoutObserver(){

            public void checkoutDone(ESLocalProject project) {
                EmfStoreLocalTreeItem.this.updatedWorkspace(ESWorkspaceProvider.INSTANCE.getWorkspace(), EmfStoreLocalTreeItem.this.getExpandedItems(), EmfStoreLocalTreeItem.this.getSelectedItems(EmfStoreLocalTreeItem.this.getSelectionModel()), (SelectionModel)EmfStoreLocalTreeItem.this.getSelectionModel());
            }
        });
        ((ProjectSpace)((ESLocalProjectImpl)ESLocalProjectImpl.class.cast(root)).toInternalAPI()).getProject().addIdEObjectCollectionChangeObserver(new IdEObjectCollectionChangeObserver(){

            public void notify(Notification notification, IdEObjectCollection collection, EObject modelElement) {
            }

            public void modelElementRemoved(IdEObjectCollection collection, EObject eObject) {
                EmfStoreLocalTreeItem.this.updateProject(root, EmfStoreLocalTreeItem.this.getExpandedItems(), EmfStoreLocalTreeItem.this.getSelectedItems(EmfStoreLocalTreeItem.this.getSelectionModel()), EmfStoreLocalTreeItem.this.getSelectionModel());
            }

            public void modelElementAdded(IdEObjectCollection collection, EObject eObject) {
                EmfStoreLocalTreeItem.this.updateProject(root, EmfStoreLocalTreeItem.this.getExpandedItems(), EmfStoreLocalTreeItem.this.getSelectedItems(EmfStoreLocalTreeItem.this.getSelectionModel()), EmfStoreLocalTreeItem.this.getSelectionModel());
            }

            public void collectionDeleted(IdEObjectCollection collection) {
            }
        });
    }

    public ObservableList<TreeItem<Object>> getChildren() {
        return this.children;
    }

    private MultipleSelectionModel<?> getSelectionModel() {
        return this.view.getSelectionModel();
    }

    private List<Object> getExpandedItems() {
        ArrayList<Object> expandedItems = new ArrayList<Object>();
        return expandedItems;
    }

    private List<Object> getSelectedItems(MultipleSelectionModel<?> selectionModel) {
        ArrayList<Object> selectedItems = new ArrayList<Object>();
        return selectedItems;
    }

    private void updatedWorkspace(ESWorkspace selectedValue, List<Object> expandedItems, List<Object> selectedItems, SelectionModel<?> selectionModel) {
        ObservableList childTreeItems = super.getChildren();
        childTreeItems.clear();
        for (ESLocalProject localProject : selectedValue.getLocalProjects()) {
            EmfStoreLocalTreeItem treeItem = new EmfStoreLocalTreeItem(this.projectsView, localProject, this.view);
            childTreeItems.add((Object)treeItem);
        }
    }

    private void updateProject(ESLocalProject selectedValue, List<Object> expandedItems, List<Object> selectedItems, MultipleSelectionModel<?> selectionModel) {
        ObservableList childTreeItems = super.getChildren();
        childTreeItems.clear();
        for (Object child : selectedValue.getModelElements()) {
            AdapterFactoryTreeItem treeItem = new AdapterFactoryTreeItem(child, (AdapterFactory)this.projectsView.adapterFactory);
            childTreeItems.add((Object)treeItem);
        }
    }
}

