/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.spi.swt.core.di;

import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.InjectionException;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emfforms.common.RankingHelper;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.swt.core.AbstractSWTRenderer;
import org.eclipse.emfforms.spi.swt.core.EMFFormsRendererService;
import org.eclipse.emfforms.spi.swt.core.di.EMFFormsContextProvider;
import org.eclipse.emfforms.spi.swt.core.di.EMFFormsDIRendererService;

public class EMFFormsDIRendererFactory
implements EMFFormsRendererService<VElement> {
    private ReportService reportService;
    private final Set<EMFFormsDIRendererService<VElement>> diRendererServices = new LinkedHashSet<EMFFormsDIRendererService<VElement>>();
    private static final RankingHelper<EMFFormsDIRendererService<VElement>> RANKING_HELPER = new RankingHelper(EMFFormsDIRendererService.class, Double.MIN_VALUE, Double.valueOf(Double.NaN));

    protected void setReportService(ReportService reportService) {
        this.reportService = reportService;
    }

    protected ReportService getReportService() {
        return this.reportService;
    }

    protected void addEMFFormsDIRendererService(EMFFormsDIRendererService<VElement> diRendererService) {
        this.diRendererServices.add(diRendererService);
    }

    protected void removeEMFFormsDIRendererService(EMFFormsDIRendererService<VElement> diRendererService) {
        this.diRendererServices.remove(diRendererService);
    }

    private EMFFormsDIRendererService<VElement> getHighestRankingRender(final VElement vElement, final ViewModelContext viewModelContext) {
        LinkedHashSet<EMFFormsDIRendererService<VElement>> rendererServicesCopy = new LinkedHashSet<EMFFormsDIRendererService<VElement>>(this.diRendererServices);
        return (EMFFormsDIRendererService)RANKING_HELPER.getHighestRankingElement(rendererServicesCopy, (RankingHelper.RankTester)new RankingHelper.RankTester<EMFFormsDIRendererService<VElement>>(){

            public double getRank(EMFFormsDIRendererService<VElement> renderer) {
                return renderer.isApplicable(vElement, viewModelContext);
            }
        });
    }

    public double isApplicable(VElement vElement, ViewModelContext viewModelContext) {
        EMFFormsDIRendererService<VElement> bestRendererService = this.getHighestRankingRender(vElement, viewModelContext);
        if (bestRendererService != null) {
            return bestRendererService.isApplicable(vElement, viewModelContext);
        }
        return Double.NaN;
    }

    public AbstractSWTRenderer<VElement> getRendererInstance(VElement vElement, ViewModelContext viewModelContext) {
        AbstractSWTRenderer rendererInstance;
        Class<?>[] elementInterfaces;
        EMFFormsDIRendererService<VElement> bestRendererService = this.getHighestRankingRender(vElement, viewModelContext);
        if (bestRendererService == null) {
            return null;
        }
        EMFFormsContextProvider contextProvider = (EMFFormsContextProvider)viewModelContext.getService(EMFFormsContextProvider.class);
        if (contextProvider == null) {
            this.reportService.report(new AbstractReport("The given ViewModelContext does not have a EMFFormsContextProvider. Hence, no renderer instance can be created."));
            return null;
        }
        IEclipseContext eclipseContext = contextProvider.getContext();
        IEclipseContext childContext = eclipseContext.createChild();
        childContext.set(ViewModelContext.class, (Object)viewModelContext);
        childContext.set(VElement.class, (Object)vElement);
        Class<?> elementClass = vElement.getClass();
        Class<?>[] classArray = elementInterfaces = elementClass.getInterfaces();
        int n = elementInterfaces.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> elementInterface = classArray[n2];
            if (VElement.class.isAssignableFrom(elementInterface)) {
                childContext.set(elementInterface, elementInterface.cast(vElement));
            }
            ++n2;
        }
        Class<AbstractSWTRenderer<VElement>> rendererClass = bestRendererService.getRendererClass();
        try {
            rendererInstance = (AbstractSWTRenderer)ContextInjectionFactory.make(rendererClass, (IEclipseContext)childContext);
        }
        catch (InjectionException ex) {
            this.reportService.report(new AbstractReport((Throwable)ex));
            return null;
        }
        return rendererInstance;
    }
}

