/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.spi.swt.table;

import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Control;

@FunctionalInterface
public interface ViewerRefreshManager {
    public static final String REFRESH_MANAGER = "refreshManager";

    public void postRefresh();

    public static ViewerRefreshManager getInstance(Viewer viewer) {
        Object result = viewer.getData(REFRESH_MANAGER);
        if (result instanceof ViewerRefreshManager) {
            return (ViewerRefreshManager)result;
        }
        Runnable refresher = ViewerRefreshManager.getRefreshRunnable(viewer);
        return () -> viewer.getControl().getDisplay().asyncExec(refresher);
    }

    public static Runnable getRefreshRunnable(Viewer viewer) {
        Control control = viewer.getControl();
        return () -> {
            if (!control.isDisposed()) {
                viewer.refresh();
            }
        };
    }
}

