/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.internal.editor.ecore.referenceservices;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecp.ui.view.swt.reference.EObjectSelectionStrategy;
import org.eclipse.emf.ecp.ui.view.swt.reference.ReferenceServiceCustomizationVendor;
import org.eclipse.emfforms.bazaar.Create;
import org.eclipse.emfforms.spi.editor.helpers.ResourceSetHelpers;
import org.osgi.service.component.annotations.Component;

@Component(name="ecoreEObjectSelectionStrategyProvider", property={"service.ranking:Integer=3"})
public class EcoreEObjectSelectionStrategyProvider
extends ReferenceServiceCustomizationVendor<EObjectSelectionStrategy>
implements EObjectSelectionStrategy.Provider {
    protected boolean handles(EObject owner, EReference reference) {
        return owner instanceof EModelElement;
    }

    @Create
    public EObjectSelectionStrategy createEObjectSelectionStrategy() {
        return new Strategy();
    }

    private static class Strategy
    implements EObjectSelectionStrategy {
        Strategy() {
        }

        public Collection<EObject> collectExistingObjects(EObject owner, EReference reference, Collection<EObject> existingObjects) {
            Collection<? extends EObject> available = this.getExistingElementsFor(owner, reference);
            if (available != null) {
                existingObjects.retainAll(available);
            }
            return existingObjects;
        }

        private Collection<? extends EObject> getExistingElementsFor(EObject owner, EReference eReference) {
            if (owner instanceof EAttribute && eReference.equals(EcorePackage.Literals.ETYPED_ELEMENT__ETYPE)) {
                return this.getExistingDataTypesFor((EAttribute)owner, eReference);
            }
            if (eReference.equals(EcorePackage.Literals.ECLASS__ESUPER_TYPES)) {
                return this.getExistingSuperTypesFor((EClass)owner, eReference);
            }
            if (eReference.equals(EcorePackage.Literals.EREFERENCE__EOPPOSITE)) {
                return this.getExistingOppositesFor((EReference)owner, eReference);
            }
            if (eReference.equals(EcorePackage.Literals.EANNOTATION__REFERENCES)) {
                return this.getExistingEAnnotationEReferencesFor((EAnnotation)owner, eReference);
            }
            return null;
        }

        private Collection<EClass> getExistingSuperTypesFor(EClass domainClass, EReference eReference) {
            List classes = ResourceSetHelpers.findAllOfTypeInResourceSet((EObject)domainClass, EClass.class, (boolean)false);
            classes.removeAll((List)domainClass.eGet((EStructuralFeature)eReference));
            classes.remove(domainClass);
            ArrayList<EClass> subTypes = new ArrayList<EClass>();
            for (EClass eClass : classes) {
                if (!domainClass.isSuperTypeOf(eClass)) continue;
                subTypes.add(eClass);
            }
            classes.removeAll(subTypes);
            return classes;
        }

        private Collection<EDataType> getExistingDataTypesFor(EAttribute owner, EReference eReference) {
            List dataTypes = ResourceSetHelpers.findAllOfTypeInResourceSet((EObject)owner, EDataType.class, (boolean)true);
            return dataTypes;
        }

        private Collection<ENamedElement> getExistingEAnnotationEReferencesFor(EAnnotation annotation, EReference eReference) {
            List namedElements = ResourceSetHelpers.findAllOfTypeInResourceSet((EObject)annotation, ENamedElement.class, (boolean)true);
            return namedElements;
        }

        private Collection<EReference> getExistingOppositesFor(EReference editReference, EReference eReference) {
            List allReferences = ResourceSetHelpers.findAllOfTypeInResourceSet((EObject)editReference, EReference.class, (boolean)false);
            allReferences.remove(editReference);
            if (editReference.getEReferenceType() != null) {
                Iterator iterator = allReferences.iterator();
                while (iterator.hasNext()) {
                    EReference ref = (EReference)iterator.next();
                    if (editReference.getEReferenceType().equals(ref.getEContainingClass())) continue;
                    iterator.remove();
                }
            }
            return allReferences;
        }
    }
}

