/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.model.presentation;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Optional;
import java.util.Scanner;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;

public final class ContributionUtil {
    private static final String MANIFEST_PATH = "META-INF/MANIFEST.MF";

    private ContributionUtil() {
    }

    public static boolean isPluginProject(IProject project) {
        try {
            return project.hasNature("org.eclipse.pde.PluginNature");
        }
        catch (CoreException ex) {
            return false;
        }
    }

    public static boolean isFragmentProject(IProject project) {
        IResource manifest;
        block3: {
            try {
                manifest = project.findMember(MANIFEST_PATH);
                if (manifest != null && IFile.class.isInstance(manifest)) break block3;
                return false;
            }
            catch (CoreException ex) {
                return false;
            }
        }
        InputStream inputStream = ((IFile)IFile.class.cast(manifest)).getContents(true);
        Scanner scanner = new Scanner(inputStream, "UTF-8");
        String content = scanner.useDelimiter("\\A").next();
        scanner.close();
        int index = content.indexOf("Fragment-Host");
        return index != -1;
    }

    public static Optional<String> parseIFile(IFile file) throws IOException, CoreException {
        if (!file.exists()) {
            return Optional.empty();
        }
        Throwable throwable = null;
        Object var2_3 = null;
        try (BufferedReader br = new BufferedReader(new InputStreamReader(file.getContents(true), file.getCharset()));){
            return Optional.ofNullable(br.lines().collect(Collectors.joining(System.lineSeparator())));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

