/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.spi.swt.table;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emfforms.common.Feature;
import org.eclipse.emfforms.common.Optional;
import org.eclipse.emfforms.common.Property;
import org.eclipse.emfforms.internal.common.SimpleProperty;
import org.eclipse.emfforms.spi.swt.table.CellLabelProviderFactory;
import org.eclipse.emfforms.spi.swt.table.ColumnConfiguration;
import org.eclipse.emfforms.spi.swt.table.ConfigurationCallback;
import org.eclipse.emfforms.spi.swt.table.EditingSupportCreator;
import org.eclipse.jface.viewers.AbstractTableViewer;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.ViewerColumn;
import org.eclipse.swt.graphics.Image;

public final class ColumnConfigurationImpl
implements ColumnConfiguration {
    private final Set<Feature> enabledFeatures;
    private final boolean resizeable;
    private final boolean moveable;
    private final int styleBits;
    private final int weight;
    private final int minWidth;
    private final IObservableValue columnText;
    private final IObservableValue tooltipText;
    private final CellLabelProviderFactory labelProviderFactory;
    private final Optional<EditingSupportCreator> editingSupportCreator;
    private final Optional<Image> image;
    private final Map<String, Object> data;
    private final List<ConfigurationCallback<AbstractTableViewer, ViewerColumn>> configurationCallbacks;
    private final Property<Boolean> visibleProperty = new SimpleProperty("isVisible", (Object)Boolean.TRUE);
    private final Property<Boolean> showFilterControlProperty = new SimpleProperty("showFilter", (Object)Boolean.FALSE);
    private final Property<Object> matchFilterProperty = new SimpleProperty("filterValue", null);

    public ColumnConfigurationImpl(Set<Feature> enabledFeatures, boolean resizeable, boolean moveable, int styleBits, int weight, int minWidth, IObservableValue columnText, IObservableValue tooltipText, CellLabelProviderFactory labelProviderFactory, EditingSupportCreator editingSupport, Image image, Map<String, Object> data, List<ConfigurationCallback<AbstractTableViewer, ViewerColumn>> configurationCallbacks) {
        this.enabledFeatures = Collections.unmodifiableSet(enabledFeatures);
        this.resizeable = resizeable;
        this.moveable = moveable;
        this.styleBits = styleBits;
        this.weight = weight;
        this.minWidth = minWidth;
        this.columnText = columnText;
        this.tooltipText = tooltipText;
        this.labelProviderFactory = labelProviderFactory;
        this.editingSupportCreator = Optional.ofNullable((Object)editingSupport);
        this.image = Optional.ofNullable((Object)image);
        if (data == null) {
            throw new IllegalArgumentException("Data map cannot be null");
        }
        this.data = data;
        this.configurationCallbacks = configurationCallbacks == null || configurationCallbacks.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(configurationCallbacks);
    }

    @Override
    public Set<Feature> getEnabledFeatures() {
        return this.enabledFeatures;
    }

    @Override
    public boolean isResizeable() {
        return this.resizeable;
    }

    @Override
    public boolean isMoveable() {
        return this.moveable;
    }

    @Override
    public int getStyleBits() {
        return this.styleBits;
    }

    @Override
    public int getWeight() {
        return this.weight;
    }

    @Override
    public int getMinWidth() {
        return this.minWidth;
    }

    @Override
    public IObservableValue getColumnText() {
        return this.columnText;
    }

    @Override
    public IObservableValue getColumnTooltip() {
        return this.tooltipText;
    }

    @Override
    public CellLabelProvider createLabelProvider(AbstractTableViewer columnViewer) {
        return this.labelProviderFactory.createCellLabelProvider(columnViewer);
    }

    CellLabelProviderFactory getLabelProviderFactory() {
        return this.labelProviderFactory;
    }

    @Override
    public Optional<EditingSupport> createEditingSupport(AbstractTableViewer columnViewer) {
        if (this.editingSupportCreator.isPresent()) {
            return Optional.of((Object)((EditingSupportCreator)this.editingSupportCreator.get()).createEditingSupport(columnViewer));
        }
        return Optional.empty();
    }

    Optional<EditingSupportCreator> getEditingSupportCreator() {
        return this.editingSupportCreator;
    }

    @Override
    public Optional<Image> getColumnImage() {
        return this.image;
    }

    @Override
    public void setData(Map<String, Object> data) {
        this.data.putAll(data);
    }

    @Override
    public Object getData(String key) {
        return this.data.get(key);
    }

    @Override
    public Map<String, Object> getData() {
        return this.data;
    }

    @Override
    public List<ConfigurationCallback<AbstractTableViewer, ViewerColumn>> getConfigurationCallbacks() {
        return this.configurationCallbacks;
    }

    @Override
    public Property<Boolean> visible() {
        return this.visibleProperty;
    }

    @Override
    public Property<Boolean> showFilterControl() {
        return this.showFilterControlProperty;
    }

    @Override
    public Property<Object> matchFilter() {
        return this.matchFilterProperty;
    }

    @Override
    public void dispose() {
        this.visibleProperty.dispose();
        this.showFilterControlProperty.dispose();
        this.matchFilterProperty.dispose();
        this.data.clear();
    }
}

