/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.spi.swt.control.text.richtext.renderer;

import javax.inject.Inject;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.core.swt.renderer.TextControlSWTRenderer;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.template.model.VTViewTemplateProvider;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.core.services.databinding.EMFFormsDatabinding;
import org.eclipse.emfforms.spi.core.services.editsupport.EMFFormsEditSupport;
import org.eclipse.emfforms.spi.core.services.label.EMFFormsLabelProvider;
import org.eclipse.emfforms.spi.swt.core.layout.EMFFormsSWTLayoutUtil;
import org.eclipse.emfforms.spi.swt.core.util.PopupWindow;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class RichTextControlSWTRenderer
extends TextControlSWTRenderer {
    private GridData textGridData;
    private StyledText text;
    private static final String RETURN_PATTERN = "[\n]";
    private static final String CARRIAGE_PATTERN = "[\r]";
    private PopupWindow popupWindow;
    private Text innerText;
    private Binding binding;

    private void openPopUp(final StyledText text, boolean selectAll) {
        this.popupWindow = this.createPopupWindow();
        this.innerText = new Text(this.popupWindow.getContent(), 834);
        GridData layoutData = new GridData(4, 4, true, true);
        layoutData.heightHint = this.getPreferrredPopupHeight();
        this.innerText.setLayoutData((Object)layoutData);
        this.innerText.setSize(300, this.getPreferrredPopupHeight());
        this.popupWindow.getContent().pack();
        this.popupWindow.open();
        this.innerText.setFocus();
        this.innerText.setText(text.getText());
        if (selectAll) {
            this.innerText.selectAll();
        } else {
            this.innerText.setSelection(text.getSelectionRange().x, text.getSelectionRange().x + text.getSelectionCount());
        }
        this.innerText.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                if (e.text != null) {
                    e.text = e.text.replaceAll(RichTextControlSWTRenderer.CARRIAGE_PATTERN, "").replaceAll(RichTextControlSWTRenderer.RETURN_PATTERN, Text.DELIMITER);
                }
            }
        });
        this.innerText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 97 && (RichTextControlSWTRenderer.isCtrlKeyPressed(e) || RichTextControlSWTRenderer.isCommandKeyPressed(e))) {
                    RichTextControlSWTRenderer.this.innerText.selectAll();
                }
            }
        });
        this.innerText.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                RichTextControlSWTRenderer.this.storePopUpInOriginalText(text, RichTextControlSWTRenderer.this.innerText);
                RichTextControlSWTRenderer.this.popupWindow.close();
            }

            public void focusGained(FocusEvent e) {
            }
        });
        this.innerText.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                RichTextControlSWTRenderer.this.storePopUpInOriginalText(text, RichTextControlSWTRenderer.this.innerText);
                text.setCaretOffset(RichTextControlSWTRenderer.this.innerText.getCaretPosition());
            }
        });
    }

    private void storePopUpInOriginalText(StyledText originalText, Text popUpText) {
        originalText.setText(popUpText.getText());
        originalText.setSelection(popUpText.getCaretPosition());
        this.binding.updateTargetToModel();
    }

    private static boolean isCtrlKeyPressed(KeyEvent e) {
        return (e.stateMask & SWT.MODIFIER_MASK) == 262144;
    }

    private static boolean isCommandKeyPressed(KeyEvent e) {
        return (e.stateMask & SWT.MODIFIER_MASK) == 0x400000;
    }

    protected int getPreferrredPopupHeight() {
        return 450;
    }

    protected PopupWindow createPopupWindow() {
        return new PopupWindow((Control)this.text, this.getPreferrredPopupHeight(), 16, true);
    }

    @Inject
    public RichTextControlSWTRenderer(VControl vElement, ViewModelContext viewContext, ReportService reportService, EMFFormsDatabinding emfFormsDatabinding, EMFFormsLabelProvider emfFormsLabelProvider, VTViewTemplateProvider vtViewTemplateProvider, EMFFormsEditSupport emfFormsEditSupport) {
        super(vElement, viewContext, reportService, emfFormsDatabinding, emfFormsLabelProvider, vtViewTemplateProvider, emfFormsEditSupport);
    }

    protected Binding bindValue(Control text, IObservableValue modelValue, DataBindingContext dataBindingContext, UpdateValueStrategy targetToModel, UpdateValueStrategy modelToTarget) {
        ISWTObservableValue value = WidgetProperties.text((int)0).observe((Widget)this.text);
        this.binding = dataBindingContext.bindValue((IObservableValue)value, modelValue, targetToModel, modelToTarget);
        return this.binding;
    }

    protected Control createSWTControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(1).equalWidth(true).applyTo(composite);
        this.text = new StyledText(composite, this.getTextWidgetStyle());
        this.text.setData("org.eclipse.rap.rwt.customVariant", (Object)this.getTextVariantID());
        this.text.setEditable(true);
        this.text.setToolTipText(this.getTextMessage());
        GridDataFactory gdf = GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, true).span(1, 1);
        EMFFormsEditSupport editSupport = this.getEMFFormsEditSupport();
        if (editSupport.isMultiLine(((VControl)this.getVElement()).getDomainModelReference(), this.getViewModelContext().getDomainModel())) {
            gdf.hint(0, this.getTextHeightHint());
        }
        this.textGridData = gdf.create();
        this.text.setLayoutData((Object)this.textGridData);
        this.text.addMouseListener((MouseListener)new OpenPopupHandler(this.text));
        this.text.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                e.doit = true;
            }
        });
        this.text.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if (RichTextControlSWTRenderer.this.isOpenKey(e)) {
                    boolean selectAll = false;
                    if ((RichTextControlSWTRenderer.isCommandKeyPressed(e) || RichTextControlSWTRenderer.isCtrlKeyPressed(e)) && e.keyCode == 97) {
                        selectAll = true;
                    }
                    RichTextControlSWTRenderer.this.openPopUp(RichTextControlSWTRenderer.this.text, selectAll);
                }
            }
        });
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ((RichTextControlSWTRenderer)RichTextControlSWTRenderer.this).textGridData.heightHint = RichTextControlSWTRenderer.this.getTextHeightHint();
                RichTextControlSWTRenderer.this.text.setLayoutData((Object)RichTextControlSWTRenderer.this.textGridData);
                EMFFormsSWTLayoutUtil.adjustParentSize((Control)RichTextControlSWTRenderer.this.text);
            }
        });
        return composite;
    }

    protected boolean isOpenKey(KeyEvent e) {
        if (e.keyCode == 131072) {
            return false;
        }
        if (e.keyCode == 65536) {
            return false;
        }
        if (e.keyCode == 262144) {
            return false;
        }
        return e.keyCode != 0x400000;
    }

    protected void postInit() {
        super.postInit();
    }

    protected int getTextHeightHint() {
        if (this.text == null || this.text.isDisposed()) {
            return -1;
        }
        int lineCount = this.text.getLineCount();
        int height = lineCount * this.text.getLineHeight();
        int maxHeight = this.getMaxTextHeight();
        int minHeight = this.getMinTextHeight();
        if (height > maxHeight) {
            height = maxHeight;
        } else if (height < minHeight) {
            height = minHeight;
        }
        return height;
    }

    protected int getMaxTextHeight() {
        if (this.text == null || this.text.isDisposed()) {
            return -1;
        }
        return this.getMaxVisibleLines() * this.text.getLineHeight();
    }

    protected int getMinTextHeight() {
        if (this.text == null || this.text.isDisposed()) {
            return -1;
        }
        return this.getMinVisibleLines() * this.text.getLineHeight();
    }

    protected int getMinVisibleLines() {
        return 2;
    }

    protected int getMaxVisibleLines() {
        return 10;
    }

    private final class OpenPopupHandler
    implements MouseListener {
        private final StyledText text;

        private OpenPopupHandler(StyledText text) {
            this.text = text;
        }

        public void mouseUp(MouseEvent e) {
            RichTextControlSWTRenderer.this.openPopUp(this.text, false);
        }

        public void mouseDown(MouseEvent e) {
        }

        public void mouseDoubleClick(MouseEvent e) {
        }
    }
}

