/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.spi.core.swt;

import java.util.Set;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.observable.IObserving;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.emf.databinding.EMFDataBindingContext;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.edit.spi.swt.util.SWTValidationHelper;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.model.DomainModelReferenceChangeListener;
import org.eclipse.emf.ecp.view.spi.model.LabelAlignment;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emf.ecp.view.spi.renderer.NoPropertyDescriptorFoundExeption;
import org.eclipse.emf.ecp.view.spi.renderer.NoRendererFoundException;
import org.eclipse.emf.ecp.view.spi.swt.reporting.RenderingFailedReport;
import org.eclipse.emf.ecp.view.template.model.VTStyleProperty;
import org.eclipse.emf.ecp.view.template.model.VTViewTemplateProvider;
import org.eclipse.emf.ecp.view.template.style.mandatory.model.VTMandatoryFactory;
import org.eclipse.emf.ecp.view.template.style.mandatory.model.VTMandatoryStyleProperty;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedException;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedReport;
import org.eclipse.emfforms.spi.core.services.databinding.EMFFormsDatabinding;
import org.eclipse.emfforms.spi.core.services.label.EMFFormsLabelProvider;
import org.eclipse.emfforms.spi.core.services.label.NoLabelFoundException;
import org.eclipse.emfforms.spi.swt.core.AbstractSWTRenderer;
import org.eclipse.emfforms.spi.swt.core.EMFFormsControlProcessorService;
import org.eclipse.emfforms.spi.swt.core.layout.SWTGridCell;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Widget;

public abstract class AbstractControlSWTRenderer<VCONTROL extends VControl>
extends AbstractSWTRenderer<VCONTROL> {
    private final EMFFormsDatabinding emfFormsDatabinding;
    private final EMFFormsLabelProvider emfFormsLabelProvider;
    private final VTViewTemplateProvider vtViewTemplateProvider;
    private boolean isDisposed;
    private IObservableValue modelValue;
    private DataBindingContext dataBindingContext;
    private DomainModelReferenceChangeListener domainModelReferenceChangeListener;
    private final EMFDataBindingContext viewModelDBC;

    public AbstractControlSWTRenderer(VCONTROL vElement, ViewModelContext viewContext, ReportService reportService, EMFFormsDatabinding emfFormsDatabinding, EMFFormsLabelProvider emfFormsLabelProvider, VTViewTemplateProvider vtViewTemplateProvider) {
        super(vElement, viewContext, reportService);
        this.emfFormsDatabinding = emfFormsDatabinding;
        this.emfFormsLabelProvider = emfFormsLabelProvider;
        this.vtViewTemplateProvider = vtViewTemplateProvider;
        this.viewModelDBC = new EMFDataBindingContext();
        this.isDisposed = false;
    }

    protected EMFFormsDatabinding getEMFFormsDatabinding() {
        return this.emfFormsDatabinding;
    }

    protected EMFFormsLabelProvider getEMFFormsLabelProvider() {
        return this.emfFormsLabelProvider;
    }

    protected VTViewTemplateProvider getVTViewTemplateProvider() {
        return this.vtViewTemplateProvider;
    }

    protected void postInit() {
        super.postInit();
        this.domainModelReferenceChangeListener = new DomainModelReferenceChangeListener(){

            public void notifyChange() {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!AbstractControlSWTRenderer.this.isDisposed) {
                            AbstractControlSWTRenderer.this.applyEnable();
                        }
                    }
                });
            }
        };
        if (((VControl)this.getVElement()).getDomainModelReference() != null) {
            ((VControl)this.getVElement()).getDomainModelReference().getChangeListener().add((Object)this.domainModelReferenceChangeListener);
        }
        this.applyEnable();
    }

    public Control render(SWTGridCell cell, Composite parent) throws NoRendererFoundException, NoPropertyDescriptorFoundExeption {
        Control control = super.render(cell, parent);
        if (control == null) {
            return null;
        }
        if (!this.canHandleControlProcessor()) {
            this.defaultHandleControlProcessorForCell(control, cell);
        }
        return control;
    }

    protected boolean canHandleControlProcessor() {
        return false;
    }

    protected void defaultHandleControlProcessorForCell(Control control, SWTGridCell cell) {
        if (cell.getColumn() == 2) {
            this.defaultHandleControlProcessor(control);
        }
    }

    protected void defaultHandleControlProcessor(Control control) {
        if (this.getViewModelContext().hasService(EMFFormsControlProcessorService.class)) {
            EMFFormsControlProcessorService service = (EMFFormsControlProcessorService)this.getViewModelContext().getService(EMFFormsControlProcessorService.class);
            service.process(control, (VControl)this.getVElement(), this.getViewModelContext());
        }
    }

    protected void dispose() {
        this.isDisposed = true;
        if (((VControl)this.getVElement()).getDomainModelReference() != null) {
            ((VControl)this.getVElement()).getDomainModelReference().getChangeListener().remove((Object)this.domainModelReferenceChangeListener);
        }
        this.domainModelReferenceChangeListener = null;
        if (this.dataBindingContext != null) {
            this.dataBindingContext.dispose();
            this.dataBindingContext = null;
        }
        this.viewModelDBC.dispose();
        if (this.modelValue != null) {
            this.modelValue.dispose();
        }
        super.dispose();
    }

    protected final Image getValidationIcon(int severity) {
        return SWTValidationHelper.INSTANCE.getValidationIcon(severity, this.getVElement(), this.getViewModelContext());
    }

    protected final Color getValidationBackgroundColor(int severity) {
        if (this.isDisposed) {
            return null;
        }
        return SWTValidationHelper.INSTANCE.getValidationBackgroundColor(severity, this.getVElement(), this.getViewModelContext());
    }

    protected final DataBindingContext getDataBindingContext() {
        if (this.dataBindingContext == null) {
            this.dataBindingContext = new EMFDataBindingContext();
        }
        return this.dataBindingContext;
    }

    protected final IObservableValue getModelValue() throws DatabindingFailedException {
        if (this.modelValue == null) {
            VDomainModelReference ref = ((VControl)this.getVElement()).getDomainModelReference();
            if (ref == null) {
                throw new DatabindingFailedException(String.format("No DomainModelReference could be found for the VElement %1$s.", ((VControl)this.getVElement()).getName()));
            }
            EObject eObject = this.getViewModelContext().getDomainModel();
            EMFFormsDatabinding databindingService = this.getEMFFormsDatabinding();
            this.modelValue = databindingService.getObservableValue(ref, eObject);
        }
        return this.modelValue;
    }

    protected final EditingDomain getEditingDomain(EObject domainModel) {
        return AdapterFactoryEditingDomain.getEditingDomainFor((EObject)domainModel);
    }

    protected final Control createLabel(Composite parent) {
        Label label;
        block6: {
            label = null;
            if (this.hasLeftLabelAlignment()) {
                IValueProperty valueProperty;
                VDomainModelReference domainModelReference = ((VControl)this.getVElement()).getDomainModelReference();
                try {
                    valueProperty = this.getEMFFormsDatabinding().getValueProperty(domainModelReference, this.getViewModelContext().getDomainModel());
                }
                catch (DatabindingFailedException ex) {
                    this.getReportService().report((AbstractReport)new RenderingFailedReport((Throwable)ex));
                    break block6;
                }
                catch (IllegalArgumentException ex) {
                    this.getReportService().report(new AbstractReport((Throwable)ex));
                    break block6;
                }
                EMFFormsLabelProvider labelProvider = this.getEMFFormsLabelProvider();
                label = new Label(parent, 0);
                label.setData("org.eclipse.rap.rwt.customVariant", (Object)"org_eclipse_emf_ecp_control_label");
                label.setBackground(parent.getBackground());
                EObject rootObject = this.getViewModelContext().getDomainModel();
                try {
                    ISWTObservableValue textObservable = WidgetProperties.text().observe((Widget)label);
                    IObservableValue displayNameObservable = labelProvider.getDisplayName(domainModelReference, rootObject);
                    this.viewModelDBC.bindValue((IObservableValue)textObservable, displayNameObservable, null, new UpdateValueStrategy(){

                        public Object convert(Object value) {
                            String extra = "";
                            VTMandatoryStyleProperty mandatoryStyle = AbstractControlSWTRenderer.this.getMandatoryStyle();
                            EStructuralFeature structuralFeature = (EStructuralFeature)valueProperty.getValueType();
                            if (mandatoryStyle.isHighliteMandatoryFields() && structuralFeature.getLowerBound() > 0) {
                                extra = mandatoryStyle.getMandatoryMarker();
                            }
                            String result = (String)super.convert(value);
                            return String.valueOf(result) + extra;
                        }
                    });
                    ISWTObservableValue tooltipObservable = WidgetProperties.tooltipText().observe((Widget)label);
                    IObservableValue descriptionObservable = labelProvider.getDescription(domainModelReference, rootObject);
                    this.viewModelDBC.bindValue((IObservableValue)tooltipObservable, descriptionObservable);
                }
                catch (NoLabelFoundException e) {
                    this.getReportService().report((AbstractReport)new RenderingFailedReport((Throwable)e));
                }
            }
        }
        return label;
    }

    protected boolean hasLeftLabelAlignment() {
        return ((VControl)this.getVElement()).getLabelAlignment() == LabelAlignment.LEFT || ((VControl)this.getVElement()).getLabelAlignment() == LabelAlignment.DEFAULT;
    }

    private VTMandatoryStyleProperty getMandatoryStyle() {
        if (this.vtViewTemplateProvider == null) {
            return this.getDefaultStyle();
        }
        Set styleProperties = this.vtViewTemplateProvider.getStyleProperties(this.getVElement(), this.getViewModelContext());
        for (VTStyleProperty styleProperty : styleProperties) {
            if (!VTMandatoryStyleProperty.class.isInstance(styleProperty)) continue;
            return (VTMandatoryStyleProperty)styleProperty;
        }
        return this.getDefaultStyle();
    }

    private VTMandatoryStyleProperty getDefaultStyle() {
        return VTMandatoryFactory.eINSTANCE.createMandatoryStyleProperty();
    }

    protected final Label createValidationIcon(Composite composite) {
        Label validationLabel = new Label(composite, 0);
        validationLabel.setBackground(composite.getBackground());
        return validationLabel;
    }

    protected void applyEnable() {
        for (SWTGridCell gridCell : this.getControls().keySet()) {
            try {
                boolean observedNotNull = ((IObserving)this.getModelValue()).getObserved() != null;
                boolean enabled = observedNotNull && ((VControl)this.getVElement()).isEnabled();
                this.setControlEnabled(gridCell, (Control)this.getControls().get(gridCell), enabled);
                if (!Boolean.FALSE.equals(enabled)) continue;
                ((VControl)this.getVElement()).setDiagnostic(null);
            }
            catch (DatabindingFailedException ex) {
                this.getReportService().report((AbstractReport)new DatabindingFailedReport((Throwable)ex));
                this.setControlEnabled(gridCell, (Control)this.getControls().get(gridCell), false);
                ((VControl)this.getVElement()).setDiagnostic(null);
            }
        }
    }
}

