/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.template.controls.swt;

import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.edit.internal.swt.controls.AbstractTextControl;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;

public class TemplateColorControl
extends AbstractTextControl {
    private final Map<String, Color> colors = new LinkedHashMap<String, Color>();

    protected void fillControlComposite(final Composite composite) {
        Composite main = new Composite(composite, 0);
        GridLayoutFactory.fillDefaults().numColumns(3).applyTo(main);
        GridDataFactory.fillDefaults().grab(true, false).align(4, 1).applyTo((Control)main);
        super.fillControlComposite(main);
        Label color = new Label(main, 2048);
        GridDataFactory.fillDefaults().grab(true, false).align(4, 4).applyTo((Control)color);
        color.setText("Select Color");
        color.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
                ColorDialog cd = new ColorDialog(composite.getShell());
                cd.setText("Select Color");
                cd.setRGB(((Color)TemplateColorControl.this.colors.get(TemplateColorControl.this.getDomainModelReference().getIterator().next())).getRGB());
                RGB rgb = cd.open();
                if (rgb == null) {
                    return;
                }
                String red = Integer.toHexString(0x100 | rgb.red).substring(1);
                String green = Integer.toHexString(0x100 | rgb.green).substring(1);
                String blue = Integer.toHexString(0x100 | rgb.blue).substring(1);
                String result = String.valueOf(red) + green + blue;
                ((EStructuralFeature.Setting)TemplateColorControl.this.getDomainModelReference().getIterator().next()).set((Object)result);
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        ISWTObservableValue observeBackground = SWTObservables.observeBackground((Control)color);
        this.getDataBindingContext().bindValue((IObservableValue)observeBackground, this.getModelValue(), new UpdateValueStrategy(){

            public Object convert(Object value) {
                if (value == null) {
                    return "";
                }
                Color color = (Color)value;
                String red = Integer.toHexString(0x100 | color.getRed()).substring(1);
                String green = Integer.toHexString(0x100 | color.getGreen()).substring(1);
                String blue = Integer.toHexString(0x100 | color.getBlue()).substring(1);
                return String.valueOf(red) + green + blue;
            }
        }, new UpdateValueStrategy(){

            public Object convert(Object value) {
                if (value == null) {
                    return null;
                }
                String colorHex = (String)value;
                if (!TemplateColorControl.this.colors.containsKey(value)) {
                    String redString = colorHex.substring(0, 2);
                    String greenString = colorHex.substring(2, 4);
                    String blueString = colorHex.substring(4, 6);
                    int red = Integer.parseInt(redString, 16);
                    int green = Integer.parseInt(greenString, 16);
                    int blue = Integer.parseInt(blueString, 16);
                    TemplateColorControl.this.colors.put(colorHex, new Color((Device)Display.getDefault(), red, green, blue));
                }
                return TemplateColorControl.this.colors.get(colorHex);
            }
        });
        color.setToolTipText("Press to select the color");
    }

    protected String getTextVariantID() {
        return "org_eclipse_emf_ecp_view_template_control_color";
    }

    protected String getUnsetLabelText() {
        return "No Color set";
    }

    protected String getUnsetButtonTooltip() {
        return "Unset Color";
    }

    public void dispose() {
        for (Color color : this.colors.values()) {
            color.dispose();
        }
        super.dispose();
    }
}

