/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.zip;

import java.io.File;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ZipFileIndexEntry
implements Comparable<ZipFileIndexEntry> {
    public static final ZipFileIndexEntry[] EMPTY_ARRAY = new ZipFileIndexEntry[0];
    String dir;
    boolean isDir;
    String name;
    int offset;
    int size;
    int compressedSize;
    long javatime;
    private int nativetime;

    public ZipFileIndexEntry(String string) {
        int n = string.lastIndexOf(File.separatorChar);
        if (n == -1) {
            this.dir = "".intern();
            this.name = string;
        } else {
            this.dir = string.substring(0, n).intern();
            this.name = string.substring(n + 1);
        }
    }

    public ZipFileIndexEntry(String string, String string2) {
        this.dir = string.intern();
        this.name = string2;
    }

    public String getName() {
        if (this.dir == null || this.dir.length() == 0) {
            return this.name;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.dir);
        stringBuilder.append(File.separatorChar);
        stringBuilder.append(this.name);
        return stringBuilder.toString();
    }

    public String getFileName() {
        return this.name;
    }

    public long getLastModified() {
        if (this.javatime == 0L) {
            this.javatime = ZipFileIndexEntry.dosToJavaTime(this.nativetime);
        }
        return this.javatime;
    }

    private static long dosToJavaTime(int n) {
        return n;
    }

    void setNativeTime(int n) {
        this.nativetime = n;
    }

    public boolean isDirectory() {
        return this.isDir;
    }

    @Override
    public int compareTo(ZipFileIndexEntry zipFileIndexEntry) {
        int n;
        String string = zipFileIndexEntry.dir;
        if (this.dir != string && (n = this.dir.compareTo(string)) != 0) {
            return n;
        }
        return this.name.compareTo(zipFileIndexEntry.name);
    }

    public String toString() {
        return this.isDir ? "Dir:" + this.dir + " : " + this.name : this.dir + ":" + this.name;
    }
}

