/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.concurrent.spec.ManagedScheduledExecutorService.resourcedef;

import ee.jakarta.tck.concurrent.common.context.providers.IntContextProvider;
import ee.jakarta.tck.concurrent.common.context.providers.StringContextProvider;
import ee.jakarta.tck.concurrent.framework.TestClient;
import ee.jakarta.tck.concurrent.framework.URLBuilder;
import ee.jakarta.tck.concurrent.framework.junit.anno.Assertion;
import ee.jakarta.tck.concurrent.framework.junit.anno.Challenge;
import ee.jakarta.tck.concurrent.framework.junit.anno.Common;
import ee.jakarta.tck.concurrent.framework.junit.anno.Full;
import ee.jakarta.tck.concurrent.framework.junit.anno.TestName;
import ee.jakarta.tck.concurrent.spec.ContextService.contextPropagate.ContextServiceDefinitionBean;
import ee.jakarta.tck.concurrent.spec.ContextService.contextPropagate.ContextServiceDefinitionInterface;
import ee.jakarta.tck.concurrent.spec.ContextService.contextPropagate.ContextServiceDefinitionServlet;
import ee.jakarta.tck.concurrent.spec.ManagedScheduledExecutorService.resourcedef.ManagedScheduledExecutorDefinitionOnEJBServlet;
import ee.jakarta.tck.concurrent.spec.ManagedScheduledExecutorService.resourcedef.ManagedScheduledExecutorDefinitionServlet;
import ee.jakarta.tck.concurrent.spec.ManagedScheduledExecutorService.resourcedef.ManagedScheduledExecutorDefinitionWebBean;
import ee.jakarta.tck.concurrent.spec.ManagedScheduledExecutorService.resourcedef.ReqBean;
import jakarta.enterprise.concurrent.spi.ThreadContextProvider;
import java.net.URL;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.EnterpriseArchive;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;

@Full
@RunAsClient
public class ManagedScheduledExecutorDefinitionFullTests
extends TestClient {
    @ArquillianResource(value=ManagedScheduledExecutorDefinitionServlet.class)
    private URL baseURL;
    @ArquillianResource(value=ManagedScheduledExecutorDefinitionOnEJBServlet.class)
    private URL ejbContextURL;
    @TestName
    private String testname;

    @Deployment(name="ManagedScheduledExecutorDefinitionTests")
    public static EnterpriseArchive createDeployment() {
        WebArchive war = (WebArchive)((WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"ManagedScheduledExecutorDefinitionTests_web.war")).addPackages(true, new String[]{Common.PACKAGE.CONTEXT.getPackageName(), Common.PACKAGE.CONTEXT_PROVIDERS.getPackageName()})).addClasses(new Class[]{ReqBean.class, ManagedScheduledExecutorDefinitionServlet.class, ManagedScheduledExecutorDefinitionOnEJBServlet.class, ContextServiceDefinitionServlet.class})).addAsServiceProvider(ThreadContextProvider.class.getName(), new String[]{IntContextProvider.class.getName(), StringContextProvider.class.getName()});
        JavaArchive jar = (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"ManagedScheduledExecutorDefinitionTests_ejb.jar")).addPackages(false, new Package[]{ManagedScheduledExecutorDefinitionFullTests.class.getPackage()})).deleteClasses(new Class[]{ReqBean.class, ManagedScheduledExecutorDefinitionWebBean.class, ManagedScheduledExecutorDefinitionServlet.class, ManagedScheduledExecutorDefinitionOnEJBServlet.class})).addClasses(new Class[]{ContextServiceDefinitionInterface.class, ContextServiceDefinitionBean.class})).addAsManifestResource(ManagedScheduledExecutorDefinitionFullTests.class.getPackage(), "ejb-jar.xml", "ejb-jar.xml");
        EnterpriseArchive ear = (EnterpriseArchive)((EnterpriseArchive)ShrinkWrap.create(EnterpriseArchive.class, (String)"ManagedScheduledExecutorDefinitionTests.ear")).addAsModules(new Archive[]{war, jar});
        return ear;
    }

    @Override
    protected String getServletPath() {
        return "ManagedScheduledExecutorDefinitionServlet";
    }

    @Assertion(id="GIT:154", strategy="ManagedScheduledExecutorService submits an action to run asynchronously as a CompletionStage. Dependent stages can be chained to the CompletionStage, and all stages run with the thread context of the thread from which they were created, per ManagedScheduledExecutorDefinition config.")
    public void testAsyncCompletionStageMSE() {
        this.runTest(this.baseURL, this.testname);
    }

    @Assertion(id="GIT:154", strategy="Asynchronous method runs with thread context captured from caller")
    public void testAsynchronousMethodRunsWithContext() {
        this.runTest(this.baseURL, this.testname);
    }

    @Assertion(id="GIT:154", strategy="Asynchronous method execution is constrained by executor's maxAsync")
    public void testAsynchronousMethodWithMaxAsync3() {
        this.runTest(this.baseURL, this.testname);
    }

    @Challenge(link="https://github.com/jakartaee/concurrency/issues/224", version="3.0.0")
    @Assertion(id="GIT:154", strategy="ManagedScheduledExecutorService creates a completed CompletableFuture to which async dependent stages can be chained. The dependent stages all run with the thread context of the thread from which they were created, per ManagedScheduledExecutorDefinition config.")
    public void testCompletedFutureMSE() {
        this.runTest(this.baseURL, this.testname);
    }

    @Assertion(id="GIT:154", strategy="ManagedScheduledExecutorService creates an incomplete CompletableFuture to which dependent stages can be chained. The CompletableFuture can be completed from another thread lacking the same context, but the dependent stages all run with the thread context of the thread from which they were created, per ManagedScheduledExecutorDefinition config.")
    public void testIncompleteFutureMSE() {
        this.runTest(this.baseURL, this.testname);
    }

    @Assertion(id="GIT:154", strategy="ManagedScheduledExecutorService creates an incomplete CompletableFuture to which dependent stages can be chained. The CompletableFuture can be completed from another thread lacking the same context, but the dependent stages all run with the thread context of the thread from which they were created, per ManagedScheduledExecutorDefinition config.")
    public void testIncompleteFutureMSEEJB() {
        URLBuilder requestURL = URLBuilder.get().withBaseURL(this.ejbContextURL).withPaths("ManagedScheduledExecutorDefinitionOnEJBServlet").withTestName(this.testname);
        this.runTest(requestURL);
    }

    @Assertion(id="GIT:154", strategy="ManagedScheduledExecutorDefinition with all attributes configured")
    public void testManagedScheduledExecutorDefinitionAllAttributes() {
        this.runTest(this.baseURL, this.testname);
    }

    @Assertion(id="GIT:154", strategy="ManagedScheduledExecutorDefinition defined on an EJB with all attributes configured enforces maxAsync and propagates context")
    public void testManagedScheduledExecutorDefinitionAllAttributesEJB() {
        URLBuilder requestURL = URLBuilder.get().withBaseURL(this.ejbContextURL).withPaths("ManagedScheduledExecutorDefinitionOnEJBServlet").withTestName(this.testname);
        this.runTest(requestURL);
    }

    @Assertion(id="GIT:154", strategy="ManagedScheduledExecutorDefinition with minimal attributes can run multiple async tasks concurrently and uses java:comp/DefaultContextService to determine context propagation and clearing.")
    public void testManagedScheduledExecutorDefinitionDefaults() {
        this.runTest(this.baseURL, this.testname);
    }

    @Assertion(id="GIT:154", strategy="ManagedScheduledExecutorDefinition defined on an EJB with minimal attributes can run multiple async tasks concurrently and uses java:comp/DefaultContextService to determine context propagation and clearing")
    public void testManagedScheduledExecutorDefinitionDefaultsEJB() {
        URLBuilder requestURL = URLBuilder.get().withBaseURL(this.ejbContextURL).withPaths("ManagedScheduledExecutorDefinitionOnEJBServlet").withTestName(this.testname);
        this.runTest(requestURL);
    }

    @Assertion(id="GIT:154", strategy="A method that lacks the Asynchronous annotation does not run as an asynchronous method, even if it returns a CompletableFuture.")
    public void testNotAnAsynchronousMethod() {
        this.runTest(this.baseURL, this.testname);
    }

    @Assertion(id="GIT:154", strategy="ManagedScheduledExecutorService can schedule a task with a CronTrigger")
    public void testScheduleWithCronTrigger() {
        this.runTest(this.baseURL, this.testname);
    }

    @Assertion(id="GIT:154", strategy="ManagedScheduledExecutorService can schedule a task with a ZonedTrigger implementation that uses the LastExecution methods with ZonedDateTime parameters")
    public void testScheduleWithZonedTrigger() {
        this.runTest(this.baseURL, this.testname);
    }

    @Assertion(id="GIT:439", strategy="Ensure scheduled asynchronous methods are completed when future is completed.")
    public void testScheduledAsynchCompletedFuture() {
        this.runTest(this.baseURL, this.testname);
    }

    @Assertion(id="GIT:439", strategy="Ensure scheduled asynchronous methods are completed when a non-null result is returned.")
    public void testScheduledAsynchCompletedResult() {
        this.runTest(this.baseURL, this.testname);
    }

    @Assertion(id="GIT:439", strategy="Ensure scheduled asynchronous methods are completed when an exception is thrown.")
    public void testScheduledAsynchCompletedExceptionally() {
        this.runTest(this.baseURL, this.testname);
    }

    @Assertion(id="GIT:439", strategy="Ensure overlapping scheduled asynchronous methods are skipped.")
    public void testScheduledAsynchOverlapSkipping() {
        this.runTest(this.baseURL, this.testname);
    }

    @Assertion(id="GIT:439", strategy="Ensure scheduled asynchronous methods ignore the max-async configuration. Ensure scheduled asynchronous methods honor cleared context configuration")
    public void testScheduledAsynchIgnoresMaxAsync() {
        this.runTest(this.baseURL, this.testname);
    }

    @Assertion(id="GIT:439", strategy="Ensure scheduled asynchronous methods choose closest execution time when multiple schedules are provided. Ensure scheduled asynchronous methods honor propogated context configuration")
    public void testScheduledAsynchWithMultipleSchedules() {
        this.runTest(this.baseURL, this.testname);
    }

    @Assertion(id="GIT:439", strategy="Ensure scheduled asynchronous methods are not executed when an invalid JNDI name is provided.")
    public void testScheduledAsynchWithInvalidJNDIName() {
        this.runTest(this.baseURL, this.testname);
    }

    @Assertion(id="GIT:439", strategy="Ensure scheduled asynchronous methods with void return type stop execution via completable future or exception.")
    public void testScheduledAsynchVoidReturn() {
        this.runTest(this.baseURL, this.testname);
    }
}

