/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.concurrent.spec.ManagedThreadFactory.tx;

import ee.jakarta.tck.concurrent.framework.TestClient;
import ee.jakarta.tck.concurrent.framework.URLBuilder;
import ee.jakarta.tck.concurrent.framework.junit.anno.Assertion;
import ee.jakarta.tck.concurrent.framework.junit.anno.Common;
import ee.jakarta.tck.concurrent.framework.junit.anno.Web;
import java.net.URL;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.Order;

@Web
@RunAsClient
@Common(value={Common.PACKAGE.TRANSACTION})
public class TransactionTests
extends TestClient {
    @ArquillianResource
    private URL baseURL;

    @Deployment(name="TransactionTests")
    public static WebArchive createDeployment() {
        return (WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).addPackages(true, new Package[]{TransactionTests.class.getPackage()});
    }

    @Order(value=1)
    @Assertion(id="SPEC:107 SPEC:108 SPEC:110 SPEC:111 SPEC:115 SPEC:116 SPEC:8.1 SPEC:9 SPEC:107 SPEC:108 SPEC:109", strategy="Get UserTransaction inside one task submitted by ManagedThreadFactory. Test rollback function in the submitted task.")
    public void testRollbackTransactionWithManagedThreadFactory() {
        this.runTest(URLBuilder.get().withBaseURL(this.baseURL).withPaths("/TransactionServlet").withQueries("isCommit=false").withTestName("transactionTest"));
    }

    @Order(value=2)
    @Assertion(id="SPEC:107 SPEC:108 SPEC:110 SPEC:111 SPEC:115 SPEC:116 SPEC:8.1 SPEC:9 SPEC:107 SPEC:109 SPEC:113 SPEC:118 SPEC:113 SPEC:118", strategy="Get UserTransaction inside one task submitted by ManagedThreadFactory. It support user-managed global transaction demarcation using the jakarta.transaction.UserTransaction interface.")
    public void testCommitTransactionWithManagedThreadFactory() throws InterruptedException {
        this.runTest(URLBuilder.get().withBaseURL(this.baseURL).withPaths("/TransactionServlet").withQueries("isCommit=true").withTestName("transactionTest"));
    }

    @Order(value=3)
    @Assertion(id="SPEC:107 SPEC:108 SPEC:110 SPEC:111 SPEC:115 SPEC:116 SPEC:8.1 SPEC:9", strategy="Get UserTransaction inside one task submitted by ManagedThreadFactory.cancel the task after submit one task.")
    public void testCancelTransactionWithManagedThreadFactory() {
        this.runTest(URLBuilder.get().withBaseURL(this.baseURL).withPaths("/TransactionServlet").withQueries("isCommit=cancel").withTestName("cancelTest"));
    }
}

