/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.concurrent.spec.ManagedExecutorService.resourcedef;

import ee.jakarta.tck.concurrent.common.context.IntContext;
import ee.jakarta.tck.concurrent.common.context.StringContext;
import ee.jakarta.tck.concurrent.framework.TestServlet;
import ee.jakarta.tck.concurrent.spec.ContextService.contextPropagate.ContextServiceDefinitionInterface;
import ee.jakarta.tck.concurrent.spec.ManagedExecutorService.resourcedef.AppBean;
import ee.jakarta.tck.concurrent.spec.ManagedExecutorService.resourcedef.ManagedExecutorDefinitionInterface;
import jakarta.annotation.Resource;
import jakarta.ejb.EJB;
import jakarta.enterprise.concurrent.ManagedExecutorService;
import jakarta.inject.Inject;
import jakarta.servlet.annotation.WebServlet;
import jakarta.transaction.UserTransaction;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.junit.jupiter.api.Assertions;

@WebServlet(value={"/ManagedExecutorDefinitionOnEJBServlet"})
public class ManagedExecutorDefinitionOnEJBServlet
extends TestServlet {
    private static final long serialVersionUID = 1L;
    private static final long MAX_WAIT_SECONDS = TimeUnit.MINUTES.toSeconds(2L);
    @Inject
    private AppBean appBean;
    @Resource
    private UserTransaction tx;
    @EJB
    private ManagedExecutorDefinitionInterface managedExecutorDefinitionBean;
    @EJB
    private ContextServiceDefinitionInterface contextServiceDefinitionBean;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testIncompleteFutureEJB() throws Throwable {
        ManagedExecutorService executor = (ManagedExecutorService)InitialContext.doLookup("java:app/concurrent/EJBExecutorA");
        try {
            IntContext.set(181);
            StringContext.set("testIncompleteFutureEJB-1");
            CompletableFuture stage1 = executor.newIncompleteFuture();
            IntContext.set(182);
            CompletionStage stage2a = stage1.thenApplyAsync(sep -> {
                int i = IntContext.get();
                return "IntContext " + (String)(i == 182 ? "propagated" : "incorrect:" + i) + sep;
            });
            CompletionStage stage2b = stage1.thenApply(sep -> {
                String s = StringContext.get();
                return "StringContext " + (String)("".equals(s) ? "cleared" : "incorrect:" + s) + sep;
            });
            IntContext.set(183);
            CompletionStage stage3 = ((CompletableFuture)stage2a).thenCombineAsync(stage2b, (status1, status2) -> {
                try {
                    ManagedExecutorService mes = (ManagedExecutorService)InitialContext.doLookup("java:app/concurrent/EJBExecutorA");
                    return status1 + status2 + "Application context " + (mes == null ? "incorrect" : "propagated");
                }
                catch (NamingException x) {
                    throw new CompletionException(x);
                }
            });
            stage1.complete(";");
            String result = (String)((CompletableFuture)stage3).join();
            Assertions.assertEquals((Object)result, (Object)"IntContext propagated;StringContext cleared;Application context propagated", (String)"Application context and IntContext must be propagated and StringContext must be cleared per ManagedExecutorDefinition and ContextServiceDefinition config.");
        }
        finally {
            IntContext.set(0);
            StringContext.set(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCopyCompletableFutureEJB() throws Throwable {
        ManagedExecutorService executor = (ManagedExecutorService)this.managedExecutorDefinitionBean.doLookup("java:module/concurrent/ExecutorB");
        IntContext.set(271);
        StringContext.set("testCopyCompletableFutureEJB-1");
        try {
            CompletableFuture<Character> stage1unmanaged = new CompletableFuture<Character>();
            CompletableFuture stage1copy = executor.copy(stage1unmanaged);
            CompletableFuture permanentlyIncompleteStage = new CompletableFuture();
            StringContext.set("testCopyCompletableFutureEJB-2");
            CompletionStage stage2 = stage1copy.applyToEitherAsync((CompletionStage)permanentlyIncompleteStage, sep -> {
                String s = StringContext.get();
                return "StringContext " + (String)("testCopyCompletableFutureEJB-2".equals(s) ? "propagated" : "incorrect:" + s) + sep;
            });
            StringContext.set("testCopyCompletableFutureEJB-3");
            CompletionStage stage3 = ((CompletableFuture)stage2).handleAsync((result, failure) -> {
                if (failure == null) {
                    int i = IntContext.get();
                    return result + "IntContext " + (String)(i == 0 ? "unchanged" : "incorrect:" + i);
                }
                throw (AssertionError)((Object)((Throwable)((Object)new AssertionError())).initCause((Throwable)failure));
            });
            Assertions.assertTrue((boolean)stage1unmanaged.complete(Character.valueOf(';')), (String)"Completation stage that is supplied to copy must not be modified by the ManagedExecutorService.");
            String result2 = (String)((CompletableFuture)stage3).get(MAX_WAIT_SECONDS, TimeUnit.SECONDS);
            Assertions.assertEquals((Object)result2, (Object)"StringContext propagated;IntContext unchanged", (String)"StringContext must be propagated and Application context and IntContext must be left unchanged per ManagedExecutorDefinition and ContextServiceDefinition config.");
        }
        finally {
            IntContext.set(0);
            StringContext.set(null);
        }
    }
}

