/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;

public class SupportUtil {
    public static Hashtable<String, Object> getAllStackTracesAsMap() {
        Hashtable<String, Object> ht = new Hashtable<String, Object>();
        try {
            Map<Thread, StackTraceElement[]> map = Thread.getAllStackTraces();
            Iterator<Map.Entry<Thread, StackTraceElement[]>> itr = map.entrySet().iterator();
            Map.Entry<Thread, StackTraceElement[]> me = null;
            while (itr.hasNext()) {
                me = itr.next();
                Thread thr = me.getKey();
                StackTraceElement[] stes = me.getValue();
                String name = String.valueOf(thr) + " 0x" + Long.toHexString(thr.hashCode());
                Vector<String> value = new Vector<String>();
                for (StackTraceElement ste : stes) {
                    value.add(ste.toString());
                }
                ht.put(name, value);
            }
        }
        catch (Throwable thr) {
            ht.put("error", "Can not getStackTrace " + String.valueOf(thr));
        }
        return ht;
    }

    public static String getAllStackTraces(String prefix) {
        try {
            Map<Thread, StackTraceElement[]> map = Thread.getAllStackTraces();
            Iterator<Map.Entry<Thread, StackTraceElement[]>> itr = map.entrySet().iterator();
            Map.Entry<Thread, StackTraceElement[]> me = null;
            StringBuilder retstr = new StringBuilder();
            while (itr.hasNext()) {
                me = itr.next();
                Thread thr = me.getKey();
                StackTraceElement[] stes = me.getValue();
                retstr.append(prefix + String.valueOf(thr) + " 0x" + Long.toHexString(thr.hashCode()) + "\n");
                for (int i = 0; i < stes.length; ++i) {
                    retstr.append(prefix + "\t" + String.valueOf(stes[i]) + "\n");
                }
                retstr.append('\n');
            }
            return retstr.toString();
        }
        catch (Throwable thr) {
            return prefix + "Can not getStackTrace " + String.valueOf(thr);
        }
    }

    public static String getStackTrace(String prefix) {
        Thread thr = Thread.currentThread();
        try {
            Method m = Thread.class.getMethod("getStackTrace", new Class[0]);
            StackTraceElement[] stes = (StackTraceElement[])m.invoke((Object)thr, new Object[0]);
            StringBuilder retstr = new StringBuilder();
            retstr.append(prefix).append(thr).append(" 0x").append(Long.toHexString(thr.hashCode())).append('\n');
            for (StackTraceElement ste : stes) {
                retstr.append(prefix).append('\t').append(ste).append('\n');
            }
            return retstr.toString();
        }
        catch (Throwable t) {
            return prefix + "Can not getStackTrace " + String.valueOf(t);
        }
    }

    public static String getStackTraceString(Throwable e) {
        String str = null;
        try {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            str = sw.toString();
        }
        catch (Throwable t) {
            str = e.toString();
        }
        return str;
    }
}

