/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.sqlstore.sco;

import com.sun.jdo.spi.persistence.support.sqlstore.PersistenceCapable;
import com.sun.jdo.spi.persistence.support.sqlstore.PersistenceManager;
import com.sun.jdo.spi.persistence.support.sqlstore.SCODate;
import com.sun.jdo.spi.persistence.support.sqlstore.StateManager;
import java.io.ObjectStreamException;
import java.sql.Date;

public class SqlDate
extends Date
implements SCODate {
    private transient PersistenceCapable owner;
    private transient String fieldName;

    public SqlDate(Object owner, String fieldName) {
        super(0L);
        if (owner instanceof PersistenceCapable) {
            this.owner = (PersistenceCapable)owner;
            this.fieldName = fieldName;
        }
    }

    public SqlDate(Object owner, String fieldName, long date) {
        super(date);
        if (owner instanceof PersistenceCapable) {
            this.owner = (PersistenceCapable)owner;
            this.fieldName = fieldName;
        }
    }

    @Override
    public void setTime(long time) {
        this.makeDirty();
        super.setTime(time);
    }

    @Override
    public Object clone() {
        SqlDate obj = (SqlDate)super.clone();
        obj.owner = null;
        obj.fieldName = null;
        return obj;
    }

    @Override
    public void setYear(int year) {
        this.makeDirty();
        super.setYear(year);
    }

    @Override
    public void setMonth(int month) {
        this.makeDirty();
        super.setMonth(month);
    }

    @Override
    public void setDate(int date) {
        this.makeDirty();
        super.setDate(date);
    }

    @Override
    public Object cloneInternal() {
        return super.clone();
    }

    @Override
    public void setTimeInternal(long time) {
        super.setTime(time);
    }

    @Override
    public void unsetOwner() {
        this.owner = null;
        this.fieldName = null;
    }

    @Override
    public Object getOwner() {
        return this.owner;
    }

    @Override
    public String getFieldName() {
        return this.fieldName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StateManager makeDirty() {
        StateManager stateManager;
        if (this.owner != null && (stateManager = this.owner.jdoGetStateManager()) != null) {
            PersistenceManager pm = (PersistenceManager)stateManager.getPersistenceManagerInternal();
            pm.acquireShareLock();
            try {
                StateManager stateManager2 = stateManager;
                synchronized (stateManager2) {
                    block9: {
                        if (this.owner == null) break block9;
                        stateManager.makeDirty(this.fieldName);
                        StateManager stateManager3 = stateManager;
                        return stateManager3;
                    }
                }
            }
            finally {
                pm.releaseShareLock();
            }
        }
        return null;
    }

    @Override
    public void applyUpdates(StateManager sm, boolean modified) {
    }

    Object writeReplace() throws ObjectStreamException {
        return new Date(this.getTime());
    }
}

