/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.io.txnlog.file;

import com.sun.messaging.jmq.io.txnlog.file.FileTransactionLogRecord;
import com.sun.messaging.jmq.io.txnlog.file.FileTransactionLogWriter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class FileLogRecordIterator
implements Iterator {
    private FileTransactionLogWriter lwriter = null;
    private RandomAccessFile raf = null;
    private long cpPosition = -1L;
    private long cpSequence = -1L;
    private FileTransactionLogRecord entry = null;
    private FileTransactionLogRecord[] compoundEntries = null;
    private int compoundEntryIndex = 0;
    private boolean eof = false;
    private long ct = 0L;
    private long entrySequence = 0L;
    private boolean debug = Boolean.getBoolean("imq.txnlog.debug");

    public FileLogRecordIterator(FileTransactionLogWriter writer) throws IOException {
        this.lwriter = writer;
        this.raf = this.lwriter.getRAF();
        this.cpPosition = this.lwriter.getCPPosition();
        this.cpSequence = this.lwriter.getCPSequence();
        this.raf.seek(this.cpPosition);
        this.readNextRecord();
    }

    @Override
    public synchronized boolean hasNext() {
        return this.entry != null;
    }

    public synchronized Object next() {
        if (this.eof) {
            throw new NoSuchElementException();
        }
        if (this.entry != null) {
            FileTransactionLogRecord lrec = this.entry;
            if (this.compoundEntries != null) {
                if (this.compoundEntryIndex < this.compoundEntries.length - 1) {
                    ++this.compoundEntryIndex;
                    this.entry = this.compoundEntries[this.compoundEntryIndex];
                    if (this.debug) {
                        this.log("setting next entry to a compound sub record");
                    }
                    return lrec;
                }
                if (this.debug) {
                    this.log("This is the last compound sub record");
                }
                this.compoundEntries = null;
                this.compoundEntryIndex = 0;
            }
            this.entry = null;
            this.readNextRecord();
            return lrec;
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Unsupported Operation.");
    }

    private synchronized void readNextRecord() {
        if (this.debug) {
            this.log("readNextRecord");
        }
        if (this.eof) {
            return;
        }
        try {
            long calculated;
            byte[] bytes = new byte[48];
            int bread = this.raf.read(bytes);
            if (bread < 48) {
                this.log("Reached end of file., records read: " + this.ct);
                this.eof = true;
                return;
            }
            ByteBuffer buf = ByteBuffer.wrap(bytes);
            int magic = buf.getInt();
            int rtype = buf.getInt();
            int bsize = buf.getInt();
            long timestamp = buf.getLong();
            if (magic != -1431677611) {
                this.log("Reached end of file. No Magic number., records read: " + this.ct);
                this.eof = true;
                return;
            }
            long seq = buf.getLong();
            long cpseq = buf.getLong();
            byte[] body = new byte[bsize];
            int rsize = this.raf.read(body);
            if (rsize < bsize) {
                this.log("Reached end of file. Body read reached EOF. records read: " + this.ct);
                this.eof = true;
                return;
            }
            long valueSet = buf.getLong();
            if (valueSet != (calculated = this.lwriter.calculateCheckSum(body))) {
                this.log("Reached end of file.  Check sum not validate., records read: " + this.ct);
                this.eof = true;
                return;
            }
            if (cpseq != this.cpSequence) {
                this.log("Reached end of check point.  records read: " + this.ct);
                this.eof = true;
                return;
            }
            if (seq != this.entrySequence) {
                this.log("Entry sequence is not valid. Expected: " + this.entrySequence + ", but read: " + seq + ", total records read: " + this.ct);
                this.eof = true;
                return;
            }
            ++this.entrySequence;
            this.entry = new FileTransactionLogRecord(timestamp, rtype, seq);
            this.entry.setCheckPointSequence(cpseq);
            this.entry.setBody(body);
            if (this.entry.getType() == 8) {
                this.processCompoundTransactionLogRecord();
            }
            ++this.ct;
        }
        catch (Exception e) {
            this.eof = true;
        }
    }

    private void processCompoundTransactionLogRecord() {
        FileTransactionLogRecord compoundRecord = this.entry;
        byte[] compoundBody = compoundRecord.getBody();
        ByteBuffer buf = ByteBuffer.wrap(compoundBody);
        int numEntries = buf.getInt();
        if (this.debug) {
            this.log("processCompoundTransactionLogRecord numEntries=" + numEntries);
        }
        this.compoundEntries = new FileTransactionLogRecord[numEntries];
        this.compoundEntryIndex = 0;
        for (int i = 0; i < numEntries; ++i) {
            FileTransactionLogRecord subEntry = new FileTransactionLogRecord(this.entry.getTimestamp(), this.entry.getType(), this.entry.getSequence());
            subEntry.setCheckPointSequence(this.entry.getCheckPointSequence());
            this.compoundEntries[i] = subEntry;
            int rtype = buf.getInt();
            subEntry.setType(rtype);
            int bsize = buf.getInt();
            byte[] subBody = new byte[bsize];
            buf.get(subBody);
            subEntry.setBody(subBody);
        }
        this.entry = this.compoundEntries[0];
    }

    private void log(String msg) {
        if (this.debug) {
            System.out.println(String.valueOf(new Date()) + ": " + msg);
        }
    }

    public static void main(String[] args) throws Exception {
        String fname = "MQTxn.log";
        if (args.length > 0) {
            fname = args[0];
        }
        int nrec = 0;
        FileTransactionLogWriter lwriter = new FileTransactionLogWriter(fname);
        if (lwriter.playBackRequired()) {
            Iterator it = lwriter.iterator();
            nrec = 0;
            while (it.hasNext()) {
                Object obj = it.next();
                System.out.println(obj.toString());
                ++nrec;
            }
        } else {
            System.out.println("*** No playback is required.");
        }
        System.out.println("*** Read Txn log file: " + fname + ", nrec: " + nrec);
    }
}

