/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.api.admin;

import org.glassfish.api.ActionReport;

public interface AdminCommandState {
    public static final String EVENT_STATE_CHANGED = "AdminCommandState/stateChanged";

    default public boolean isJobStillActive() {
        return State.PREPARED.equals((Object)this.getState()) || State.RUNNING.equals((Object)this.getState()) || State.RUNNING_RETRYABLE.equals((Object)this.getState());
    }

    public State getState();

    public ActionReport getActionReport();

    public boolean isOutboundPayloadEmpty();

    public String getId();

    public String getName();

    public static enum State {
        PREPARED,
        RUNNING,
        COMPLETED,
        RECORDED,
        RUNNING_RETRYABLE,
        FAILED_RETRYABLE,
        REVERTING,
        REVERTED;


        public static boolean isAllowedTransition(State from, State to) {
            switch (from.ordinal()) {
                case 0: {
                    return to == RUNNING;
                }
                case 1: {
                    return to == COMPLETED || to == FAILED_RETRYABLE || to == REVERTING;
                }
                case 2: {
                    return to == RECORDED;
                }
                case 3: {
                    return false;
                }
                case 4: {
                    return to == COMPLETED || to == FAILED_RETRYABLE || to == REVERTING;
                }
                case 5: {
                    return to == RUNNING_RETRYABLE || to == REVERTING;
                }
                case 6: {
                    return to == REVERTED;
                }
                case 7: {
                    return false;
                }
            }
            throw new IllegalArgumentException("Unknown state: " + String.valueOf((Object)from));
        }
    }
}

