/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jdeparser;

import java.util.Arrays;

class EnumIntMap<E extends Enum<E>> {
    private final Class<E> type;
    private final E[] keys;
    private final int[] values;
    private static final ClassValue<Object> cvo = new ClassValue<Object>(){

        @Override
        protected Object computeValue(Class<?> type) {
            return type.getEnumConstants();
        }
    };

    EnumIntMap(Class<E> type, int defaultVal) {
        this.type = type;
        this.keys = (Enum[])cvo.get(type);
        this.values = new int[this.keys.length];
        Arrays.fill(this.values, defaultVal);
    }

    EnumIntMap(EnumIntMap<E> orig) {
        this.type = orig.type;
        this.keys = orig.keys;
        this.values = (int[])orig.values.clone();
    }

    public int get(E key) {
        return this.values[((Enum)this.type.cast(key)).ordinal()];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int put(E key, int val) {
        int idx = ((Enum)this.type.cast(key)).ordinal();
        try {
            int n = this.values[idx];
            return n;
        }
        finally {
            this.values[idx] = val;
        }
    }

    public static <E extends Enum<E>> EnumIntMap<E> of(Class<E> enumClass) {
        return new EnumIntMap<E>(enumClass, 0);
    }
}

