/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.lite.extension.translator;

import jakarta.annotation.Priority;
import jakarta.enterprise.context.NormalScope;
import jakarta.enterprise.inject.build.compatible.spi.BeanInfo;
import jakarta.enterprise.inject.build.compatible.spi.DisposerInfo;
import jakarta.enterprise.inject.build.compatible.spi.InjectionPointInfo;
import jakarta.enterprise.inject.build.compatible.spi.ScopeInfo;
import jakarta.enterprise.inject.build.compatible.spi.StereotypeInfo;
import jakarta.enterprise.inject.spi.Annotated;
import jakarta.enterprise.inject.spi.AnnotatedField;
import jakarta.enterprise.inject.spi.AnnotatedMethod;
import jakarta.enterprise.inject.spi.AnnotatedParameter;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.InjectionPoint;
import jakarta.enterprise.inject.spi.Prioritized;
import jakarta.enterprise.lang.model.AnnotationInfo;
import jakarta.enterprise.lang.model.declarations.ClassInfo;
import jakarta.enterprise.lang.model.declarations.FieldInfo;
import jakarta.enterprise.lang.model.declarations.MethodInfo;
import jakarta.enterprise.lang.model.types.Type;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.stream.Collectors;
import org.jboss.weld.lite.extension.translator.AnnotationInfoImpl;
import org.jboss.weld.lite.extension.translator.ClassInfoImpl;
import org.jboss.weld.lite.extension.translator.DisposerInfoImpl;
import org.jboss.weld.lite.extension.translator.FieldInfoImpl;
import org.jboss.weld.lite.extension.translator.InjectionPointInfoImpl;
import org.jboss.weld.lite.extension.translator.MethodInfoImpl;
import org.jboss.weld.lite.extension.translator.ScopeInfoImpl;
import org.jboss.weld.lite.extension.translator.StereotypeInfoImpl;
import org.jboss.weld.lite.extension.translator.TypeImpl;
import org.jboss.weld.lite.extension.translator.util.reflection.AnnotatedTypes;

class BeanInfoImpl
implements BeanInfo {
    final Bean<?> cdiBean;
    final Annotated cdiDeclaration;
    final AnnotatedParameter<?> cdiDisposerDeclaration;
    final BeanManager bm;

    BeanInfoImpl(Bean<?> cdiBean, Annotated cdiDeclaration, AnnotatedParameter<?> cdiDisposerDeclaration, BeanManager bm) {
        this.cdiBean = cdiBean;
        this.cdiDeclaration = cdiDeclaration;
        this.cdiDisposerDeclaration = cdiDisposerDeclaration;
        this.bm = bm;
    }

    @Override
    public ScopeInfo scope() {
        AnnotatedType<Annotation> scopeType = this.bm.createAnnotatedType(this.cdiBean.getScope());
        boolean isNormal = scopeType.isAnnotationPresent(NormalScope.class);
        return new ScopeInfoImpl(new ClassInfoImpl(scopeType, this.bm), isNormal);
    }

    @Override
    public Collection<Type> types() {
        return this.cdiBean.getTypes().stream().map(it -> TypeImpl.fromReflectionType(AnnotatedTypes.from(it), this.bm)).collect(Collectors.toList());
    }

    @Override
    public Collection<AnnotationInfo> qualifiers() {
        return this.cdiBean.getQualifiers().stream().map(annotation -> new AnnotationInfoImpl((Annotation)annotation, this.bm)).collect(Collectors.toList());
    }

    @Override
    public ClassInfo declaringClass() {
        AnnotatedType<?> beanClass = this.bm.createAnnotatedType(this.cdiBean.getBeanClass());
        return new ClassInfoImpl(beanClass, this.bm);
    }

    @Override
    public boolean isClassBean() {
        return this.cdiDeclaration instanceof AnnotatedType;
    }

    @Override
    public boolean isProducerMethod() {
        return this.cdiDeclaration instanceof AnnotatedMethod;
    }

    @Override
    public boolean isProducerField() {
        return this.cdiDeclaration instanceof AnnotatedField;
    }

    @Override
    public boolean isSynthetic() {
        return this.cdiDeclaration == null;
    }

    @Override
    public MethodInfo producerMethod() {
        if (this.cdiDeclaration instanceof AnnotatedMethod) {
            return new MethodInfoImpl((AnnotatedMethod)this.cdiDeclaration, this.bm);
        }
        return null;
    }

    @Override
    public FieldInfo producerField() {
        if (this.cdiDeclaration instanceof AnnotatedField) {
            return new FieldInfoImpl((AnnotatedField)this.cdiDeclaration, this.bm);
        }
        return null;
    }

    @Override
    public boolean isAlternative() {
        return this.cdiBean.isAlternative();
    }

    @Override
    public Integer priority() {
        if (this.cdiDeclaration instanceof AnnotatedType && this.cdiDeclaration.isAnnotationPresent(Priority.class)) {
            return this.cdiDeclaration.getAnnotation(Priority.class).value();
        }
        if (this.cdiBean instanceof Prioritized) {
            return ((Prioritized)((Object)this.cdiBean)).getPriority();
        }
        return null;
    }

    @Override
    public String name() {
        return this.cdiBean.getName();
    }

    @Override
    public DisposerInfo disposer() {
        if (this.cdiDisposerDeclaration != null) {
            return new DisposerInfoImpl(this.cdiDisposerDeclaration, this.bm);
        }
        return null;
    }

    @Override
    public Collection<StereotypeInfo> stereotypes() {
        return this.cdiBean.getStereotypes().stream().map(aClass -> new StereotypeInfoImpl((Class<? extends Annotation>)aClass, this.bm)).collect(Collectors.toList());
    }

    @Override
    public Collection<InjectionPointInfo> injectionPoints() {
        return this.cdiBean.getInjectionPoints().stream().map(cdiInjectionPoint -> new InjectionPointInfoImpl((InjectionPoint)cdiInjectionPoint, this.bm)).collect(Collectors.toList());
    }

    public String toString() {
        return "@" + this.cdiBean.getScope().getSimpleName() + " bean [types=" + String.valueOf(this.cdiBean.getTypes()) + ", qualifiers=" + String.valueOf(this.cdiBean.getQualifiers()) + "]" + (String)(this.cdiDeclaration != null ? " declared at " + String.valueOf(this.cdiDeclaration) : "");
    }
}

