/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.databaseaccess;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;

public class FieldTypeDefinition
implements Serializable {
    protected String name;
    protected int defaultSize = 10;
    protected int defaultSubSize;
    protected boolean isSizeAllowed = true;
    protected boolean isSizeRequired = false;
    protected int maxPrecision = 10;
    protected int minScale = 0;
    protected int maxScale = 0;
    protected boolean shouldAllowNull = true;
    protected String typesuffix = null;
    private final Set<String> aliases;

    private FieldTypeDefinition(Set<String> aliasesSet) {
        this.aliases = aliasesSet;
    }

    public FieldTypeDefinition() {
        this(Collections.emptySet());
    }

    public FieldTypeDefinition(String databaseTypeName) {
        this();
        this.name = databaseTypeName;
    }

    public FieldTypeDefinition(String databaseTypeName, int defaultSize) {
        this();
        this.name = databaseTypeName;
        this.defaultSize = defaultSize;
        this.isSizeRequired = true;
        this.setMaxPrecision(defaultSize);
    }

    public FieldTypeDefinition(String databaseTypeName, int defaultSize, int defaultSubSize) {
        this();
        this.name = databaseTypeName;
        this.defaultSize = defaultSize;
        this.defaultSubSize = defaultSubSize;
        this.isSizeRequired = true;
        this.setMaxPrecision(defaultSize);
        this.setMaxScale(defaultSubSize);
    }

    public FieldTypeDefinition(String databaseTypeName, int defaultSize, String typeSuffix) {
        this(databaseTypeName, defaultSize);
        this.typesuffix = typeSuffix;
        this.isSizeAllowed = true;
    }

    public FieldTypeDefinition(String databaseTypeName, boolean allowsSize) {
        this();
        this.name = databaseTypeName;
        this.isSizeAllowed = allowsSize;
    }

    public FieldTypeDefinition(String databaseTypeName, boolean allowsSize, String ... typeNameAliases) {
        this(FieldTypeDefinition.createAliasesSet(typeNameAliases));
        this.name = databaseTypeName;
        this.isSizeAllowed = allowsSize;
    }

    public FieldTypeDefinition(String databaseTypeName, boolean allowsSize, boolean allowsNull) {
        this(databaseTypeName, allowsSize);
        this.shouldAllowNull = allowsNull;
    }

    public int getDefaultSize() {
        return this.defaultSize;
    }

    public int getDefaultSubSize() {
        return this.defaultSubSize;
    }

    public int getMaxPrecision() {
        return this.maxPrecision;
    }

    public int getMaxScale() {
        return this.maxScale;
    }

    public int getMinScale() {
        return this.minScale;
    }

    public String getName() {
        return this.name;
    }

    public String getTypesuffix() {
        return this.typesuffix;
    }

    public boolean isSizeAllowed() {
        return this.isSizeAllowed;
    }

    public boolean isSizeRequired() {
        return this.isSizeRequired;
    }

    public boolean shouldAllowNull() {
        return this.shouldAllowNull;
    }

    public void setDefaultSize(int defaultSize) {
        this.defaultSize = defaultSize;
    }

    public void setDefaultSubSize(int defaultSubSize) {
        this.defaultSubSize = defaultSubSize;
    }

    public void setIsSizeAllowed(boolean aBoolean) {
        this.isSizeAllowed = aBoolean;
    }

    public void setIsSizeRequired(boolean aBoolean) {
        this.isSizeRequired = aBoolean;
    }

    public void setShouldAllowNull(boolean allowsNull) {
        this.shouldAllowNull = allowsNull;
    }

    public FieldTypeDefinition setLimits(int maxPrecision, int minScale, int maxScale) {
        this.setMaxPrecision(maxPrecision);
        this.setMinScale(minScale);
        this.setMaxScale(maxScale);
        return this;
    }

    public void setMaxPrecision(int maximum) {
        this.maxPrecision = maximum;
    }

    public void setMaxScale(int maximum) {
        this.maxScale = maximum;
    }

    public void setMinScale(int minimum) {
        this.minScale = minimum;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isTypeName(String typeName, boolean checkSize) {
        Objects.requireNonNull(typeName, "Checked type name is null.");
        if (!checkSize) {
            boolean match;
            boolean bl = match = (typeName = FieldTypeDefinition.removeSizeFromTypeName(typeName)).equalsIgnoreCase(this.name) || this.aliases.contains(typeName.toUpperCase());
            if (!match && !(match = FieldTypeDefinition.checkTypeNameWithSizeRemoved(typeName, this.name, match))) {
                Iterator<String> i = this.aliases.iterator();
                while (!match && i.hasNext()) {
                    String alias = i.next();
                    match = FieldTypeDefinition.checkTypeNameWithSizeRemoved(typeName, alias, match);
                }
            }
            return match;
        }
        return typeName.equalsIgnoreCase(this.name) || this.aliases.contains(typeName.toUpperCase());
    }

    private static String removeSizeFromTypeName(String typeName) {
        int sizeBeg = typeName.indexOf(40);
        if (sizeBeg > 0) {
            typeName = typeName.substring(0, sizeBeg);
        }
        return typeName;
    }

    private static boolean checkTypeNameWithSizeRemoved(String dbTypeName, String typeName, boolean match) {
        int sizeBeg;
        if (!match && (sizeBeg = typeName.indexOf(40)) > 0) {
            match = dbTypeName.equalsIgnoreCase(typeName.substring(0, sizeBeg));
        }
        return match;
    }

    public void setSizeDisallowed() {
        this.setIsSizeAllowed(false);
    }

    public void setSizeOptional() {
        this.setIsSizeRequired(false);
        this.setIsSizeAllowed(true);
    }

    public void setSizeRequired() {
        this.setIsSizeRequired(true);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.getName() + ")";
    }

    private static Set<String> createAliasesSet(String ... typeNameAliases) {
        if (typeNameAliases == null || typeNameAliases.length == 0) {
            return Collections.emptySet();
        }
        HashSet<String> aliasesSet = new HashSet<String>(typeNameAliases.length);
        for (String typeNameAlias : typeNameAliases) {
            aliasesSet.add(typeNameAlias.toUpperCase());
        }
        return Set.copyOf(aliasesSet);
    }
}

