/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.universal.io;

import com.sun.enterprise.universal.glassfish.GFLauncherUtils;
import com.sun.enterprise.util.StringUtils;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedList;

public class SmartFile {
    private String path;

    public static File sanitize(File f) {
        SmartFile sf = new SmartFile(f);
        return new File(sf.path);
    }

    public static String sanitize(String filename) {
        SmartFile sf = new SmartFile(filename);
        return sf.path;
    }

    public static String sanitizePaths(String pathsString) {
        if (!SmartFile.ok(pathsString)) {
            return pathsString;
        }
        try {
            String[] paths = pathsString.split(File.pathSeparator);
            StringBuilder sb = new StringBuilder();
            HashSet<String> pathsSet = new HashSet<String>();
            LinkedList<String> pathsList = new LinkedList<String>();
            for (String path2 : paths) {
                String path = path2;
                if (!SmartFile.ok(path) || !pathsSet.add(path = SmartFile.sanitize(path))) continue;
                pathsList.add(path);
            }
            boolean firstElement = true;
            for (String path : pathsList) {
                if (firstElement) {
                    firstElement = false;
                } else {
                    sb.append(File.pathSeparator);
                }
                sb.append(path);
            }
            return sb.toString();
        }
        catch (Exception e) {
            return pathsString;
        }
    }

    private SmartFile(File f) {
        if (f == null) {
            throw new NullPointerException();
        }
        this.convert(f.getAbsolutePath());
    }

    private SmartFile(String s) {
        if (s == null) {
            throw new NullPointerException();
        }
        s = StringUtils.removeEnclosingQuotes(s);
        this.convert(new File(s).getAbsolutePath());
    }

    private void convert(String oldPath) {
        if (GFLauncherUtils.isWindows()) {
            this.convertWindows(oldPath);
        } else {
            this.convertNix(oldPath);
        }
    }

    private void convertWindows(String oldPath) {
        try {
            this.path = new File(oldPath).getCanonicalPath();
            if (!this.path.startsWith("\\")) {
                this.path = this.path.replace('\\', '/');
            }
        }
        catch (IOException ex) {
            this.path = oldPath.replace('\\', '/');
        }
    }

    private void convertNix(String oldPath) {
        char[] p = oldPath.toCharArray();
        int to = 0;
        for (int from = 0; from < p.length; ++from) {
            if (p[from] == '/' && (from + 3 < p.length && p[from + 1] == '.' && p[from + 2] == '.' && p[from + 3] == '/' || from + 3 == p.length && p[from + 1] == '.' && p[from + 2] == '.')) {
                while (to > 0 && p[--to] != '/') {
                }
                from += 2;
                continue;
            }
            if (p[from] == '/' && (from + 2 < p.length && p[from + 1] == '.' && p[from + 2] == '/' || from + 2 == p.length && p[from + 1] == '.')) {
                ++from;
                continue;
            }
            p[to++] = p[from];
        }
        if (to > 0 && p[to - 1] == '/') {
            --to;
        }
        this.path = new String(p, 0, to);
    }

    private static boolean ok(String s) {
        return s != null && s.length() > 0;
    }
}

