/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.impl.sql.compile.ActivationClassBuilder;
import org.apache.derby.impl.sql.compile.TransactionStatementNode;
import org.apache.derby.shared.common.error.StandardException;

class SetTransactionIsolationNode
extends TransactionStatementNode {
    private int isolationLevel;

    SetTransactionIsolationNode(int n, ContextManager contextManager) {
        super(contextManager);
        this.isolationLevel = n;
    }

    @Override
    public String toString() {
        return "";
    }

    @Override
    String statementToString() {
        return "SET TRANSACTION ISOLATION";
    }

    @Override
    void generate(ActivationClassBuilder activationClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        activationClassBuilder.pushGetResultSetFactoryExpression(methodBuilder);
        activationClassBuilder.pushThisAsActivation(methodBuilder);
        methodBuilder.callMethod((short)185, null, "getSetTransactionResultSet", "org.apache.derby.iapi.sql.ResultSet", 1);
    }

    @Override
    public ConstantAction makeConstantAction() throws StandardException {
        return this.getGenericConstantActionFactory().getSetTransactionIsolationConstantAction(this.isolationLevel);
    }
}

