/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.opt.impl.incoming;

import com.sun.xml.ws.api.message.Attachment;
import com.sun.xml.ws.api.message.AttachmentSet;
import com.sun.xml.ws.api.message.HeaderList;
import com.sun.xml.ws.security.opt.api.NamespaceContextInfo;
import com.sun.xml.ws.security.opt.api.SecurityHeaderElement;
import com.sun.xml.ws.security.opt.impl.JAXBFilterProcessingContext;
import com.sun.xml.ws.security.opt.impl.crypto.AttachmentData;
import com.sun.xml.ws.security.opt.impl.incoming.GenericSecuredHeader;
import com.sun.xml.ws.security.opt.impl.incoming.SecurityContext;
import com.sun.xml.ws.security.opt.impl.incoming.StreamWriterData;
import java.util.ArrayList;
import java.util.ListIterator;
import javax.xml.crypto.Data;
import javax.xml.crypto.URIDereferencer;
import javax.xml.crypto.URIReference;
import javax.xml.crypto.URIReferenceException;
import javax.xml.crypto.XMLCryptoContext;

public class URIResolver
implements URIDereferencer {
    private final SecurityContext securityContext;
    private final JAXBFilterProcessingContext pc;

    public URIResolver(JAXBFilterProcessingContext pc) {
        this.pc = pc;
        this.securityContext = pc.getSecurityContext();
    }

    @Override
    public Data dereference(URIReference uRIReference, XMLCryptoContext xMLCryptoContext) throws URIReferenceException {
        HeaderList headers = (HeaderList)this.securityContext.getNonSecurityHeaders();
        String tmpId = uRIReference.getURI();
        if (tmpId.startsWith("cid:")) {
            return this.dereferenceAttachments(tmpId.substring(4));
        }
        String id = "";
        int index = tmpId.indexOf("#");
        id = index >= 0 ? tmpId.substring(index + 1) : tmpId;
        if (headers != null && !headers.isEmpty()) {
            ListIterator listItr = headers.listIterator();
            while (listItr.hasNext()) {
                GenericSecuredHeader header = (GenericSecuredHeader)listItr.next();
                if (!header.hasID(id) || header.hasEncData()) continue;
                return new StreamWriterData(header, header.getInscopeNSContext());
            }
        }
        ArrayList pshList = this.securityContext.getProcessedSecurityHeaders();
        for (Object element : pshList) {
            SecurityHeaderElement header = (SecurityHeaderElement)element;
            if (!id.equals(header.getId())) continue;
            if (header instanceof NamespaceContextInfo) {
                return new StreamWriterData(header, ((NamespaceContextInfo)((Object)header)).getInscopeNSContext());
            }
            throw new URIReferenceException("Cannot derefernce this MessagePart and use if for any crypto operation as the message part is not cached");
        }
        ArrayList bufList = this.securityContext.getBufferedSecurityHeaders();
        for (Object element : bufList) {
            SecurityHeaderElement header = (SecurityHeaderElement)element;
            if (!id.equals(header.getId())) continue;
            if (header instanceof NamespaceContextInfo) {
                return new StreamWriterData(header, ((NamespaceContextInfo)((Object)header)).getInscopeNSContext());
            }
            throw new URIReferenceException("Cannot derefernce this MessagePart and use if for any crypto operation as the message part is not cached");
        }
        Data data = (Data)this.pc.getSTRTransformCache().get(id);
        if (data != null) {
            return data;
        }
        return (Data)this.pc.getElementCache().get(id);
    }

    private Data dereferenceAttachments(String cidRef) throws URIReferenceException {
        AttachmentSet attachments = this.securityContext.getDecryptedAttachmentSet();
        if (attachments == null || attachments.isEmpty()) {
            attachments = this.securityContext.getAttachmentSet();
        }
        if (attachments == null || attachments.isEmpty()) {
            throw new URIReferenceException("Attachment Resource with Identifier  " + cidRef + " was not found");
        }
        Attachment attachment = attachments.get(cidRef);
        if (attachment == null) {
            throw new URIReferenceException("Attachment Resource with Identifier  " + cidRef + " was not found");
        }
        return new AttachmentData(attachment);
    }
}

