/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.services.io;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public final class InputStreamUtil {
    private static final int SKIP_FRAGMENT_SIZE = Integer.MAX_VALUE;

    public static int readUnsignedByte(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        if (n < 0) {
            throw new EOFException();
        }
        return n;
    }

    public static void readFully(InputStream inputStream, byte[] byArray, int n, int n2) throws IOException {
        int n3;
        do {
            if ((n3 = inputStream.read(byArray, n, n2)) < 0) {
                throw new EOFException();
            }
            n += n3;
        } while ((n2 -= n3) != 0);
    }

    public static int readLoop(InputStream inputStream, byte[] byArray, int n, int n2) throws IOException {
        int n3;
        int n4 = n;
        while ((n3 = inputStream.read(byArray, n, n2)) > 0) {
            n += n3;
            if ((n2 -= n3) != 0) continue;
        }
        return n - n4;
    }

    public static long skipUntilEOF(InputStream inputStream) throws IOException {
        long l;
        if (inputStream == null) {
            throw new NullPointerException();
        }
        long l2 = 0L;
        do {
            l = InputStreamUtil.skipPersistent(inputStream, Integer.MAX_VALUE);
            l2 += l;
        } while (l >= Integer.MAX_VALUE);
        return l2;
    }

    public static void skipFully(InputStream inputStream, long l) throws IOException {
        if (inputStream == null) {
            throw new NullPointerException();
        }
        if (l <= 0L) {
            return;
        }
        long l2 = InputStreamUtil.skipPersistent(inputStream, l);
        if (l2 < l) {
            throw new EOFException();
        }
    }

    public static final long skipPersistent(InputStream inputStream, long l) throws IOException {
        long l2;
        long l3;
        for (l2 = 0L; l2 < l; l2 += l3) {
            l3 = inputStream.skip(l - l2);
            if (l3 != 0L) continue;
            if (inputStream.read() == -1) break;
            l3 = 1L;
        }
        return l2;
    }
}

