/*
 * Decompiled with CFR 0.152.
 */
package javanet.staxutils.events;

import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import javanet.staxutils.events.ExtendedXMLEvent;
import javanet.staxutils.helpers.EventMatcher;
import javanet.staxutils.helpers.UnknownLocation;
import javanet.staxutils.io.XMLWriterUtils;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public abstract class AbstractXMLEvent
implements ExtendedXMLEvent,
Serializable,
Cloneable {
    protected Location location;
    protected QName schemaType;

    public AbstractXMLEvent() {
    }

    public AbstractXMLEvent(Location location) {
        this.location = location;
    }

    public AbstractXMLEvent(Location location, QName schemaType) {
        this.location = location;
        this.schemaType = schemaType;
    }

    public AbstractXMLEvent(XMLEvent that) {
        this.location = that.getLocation();
        this.schemaType = that.getSchemaType();
    }

    @Override
    public Location getLocation() {
        return this.location == null ? UnknownLocation.INSTANCE : this.location;
    }

    @Override
    public QName getSchemaType() {
        return this.schemaType;
    }

    @Override
    public Characters asCharacters() {
        return (Characters)((Object)this);
    }

    @Override
    public EndElement asEndElement() {
        return (EndElement)((Object)this);
    }

    @Override
    public StartElement asStartElement() {
        return (StartElement)((Object)this);
    }

    @Override
    public boolean isAttribute() {
        return this.getEventType() == 10;
    }

    @Override
    public boolean isCharacters() {
        switch (this.getEventType()) {
            case 4: 
            case 6: 
            case 12: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isEndDocument() {
        return this.getEventType() == 8;
    }

    @Override
    public boolean isEndElement() {
        return this.getEventType() == 2;
    }

    @Override
    public boolean isEntityReference() {
        return this.getEventType() == 9;
    }

    @Override
    public boolean isNamespace() {
        return this.getEventType() == 13;
    }

    @Override
    public boolean isProcessingInstruction() {
        return this.getEventType() == 3;
    }

    @Override
    public boolean isStartDocument() {
        return this.getEventType() == 7;
    }

    @Override
    public boolean isStartElement() {
        return this.getEventType() == 1;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Unexpected exception cloning XMLEvent", e);
        }
    }

    @Override
    public boolean matches(XMLEvent event) {
        return EventMatcher.eventsMatch(this, event);
    }

    @Override
    public void writeEvent(XMLStreamWriter writer) throws XMLStreamException {
        XMLWriterUtils.writeEvent((XMLEvent)this, writer);
    }

    @Override
    public void writeAsEncodedUnicode(Writer writer) throws XMLStreamException {
        try {
            XMLWriterUtils.writeEvent((XMLEvent)this, writer);
        }
        catch (IOException e) {
            throw new XMLStreamException(e);
        }
    }

    public String toString() {
        StringWriter writer = new StringWriter();
        try {
            this.writeAsEncodedUnicode(writer);
        }
        catch (XMLStreamException xMLStreamException) {
            // empty catch block
        }
        return writer.toString();
    }
}

