/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.renderkit.html;

import com.sun.webui.jsf.component.DropDown;
import com.sun.webui.jsf.component.Label;
import com.sun.webui.jsf.component.Table;
import com.sun.webui.jsf.component.TablePanels;
import com.sun.webui.jsf.model.Option;
import com.sun.webui.jsf.util.LogUtil;
import com.sun.webui.jsf.util.RenderingUtilities;
import com.sun.webui.jsf.util.ThemeUtilities;
import com.sun.webui.theme.Theme;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UINamingContainer;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import jakarta.faces.render.Renderer;
import java.io.IOException;

public final class TablePanelsRenderer
extends Renderer {
    private static final String[] STRING_ATTRIBUTES = new String[]{"abbr", "align", "axis", "bgColor", "char", "charOff", "dir", "headers", "height", "lang", "onClick", "onDblClick", "onKeyDown", "onKeyPress", "onKeyUp", "onMouseDown", "onMouseUp", "onMouseMove", "onMouseOut", "onMouseOver", "style", "valign", "width"};

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        if (context == null || component == null) {
            TablePanelsRenderer.log("encodeBegin", "Cannot render, FacesContext or UIComponent is null");
            throw new NullPointerException();
        }
        if (!component.isRendered()) {
            TablePanelsRenderer.log("encodeBegin", "Component not rendered, nothing to display");
            return;
        }
        TablePanels panel = (TablePanels)component;
        ResponseWriter writer = context.getResponseWriter();
        this.renderEnclosingTagStart(context, panel, writer);
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        if (context == null || component == null) {
            TablePanelsRenderer.log("encodeChildren", "Cannot render, FacesContext or UIComponent is null");
            throw new NullPointerException();
        }
        if (!component.isRendered()) {
            TablePanelsRenderer.log("encodeChildren", "Component not rendered, nothing to display");
            return;
        }
        TablePanels panel = (TablePanels)component;
        ResponseWriter writer = context.getResponseWriter();
        if (panel.isFilterPanel()) {
            this.renderFilterPanel(context, panel, writer);
        }
        if (panel.isPreferencesPanel()) {
            this.renderPreferencesPanel(context, panel, writer);
        }
        this.renderSortPanel(context, panel, writer);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        if (context == null || component == null) {
            TablePanelsRenderer.log("encodeEnd", "Cannot render, FacesContext or UIComponent is null");
            throw new NullPointerException();
        }
        if (!component.isRendered()) {
            TablePanelsRenderer.log("encodeEnd", "Component not rendered, nothing to display");
            return;
        }
        TablePanels panel = (TablePanels)component;
        ResponseWriter writer = context.getResponseWriter();
        this.renderEnclosingTagEnd(context, panel, writer);
    }

    public boolean getRendersChildren() {
        return true;
    }

    protected void renderFilterPanel(FacesContext context, TablePanels component, ResponseWriter writer) throws IOException {
        if (component == null) {
            TablePanelsRenderer.log("renderFilterPanel", "Cannot render filter panel, TablePanels is null");
            return;
        }
        Table table = component.getTableAncestor();
        UIComponent facet = table != null ? table.getFacet("filterPanel") : null;
        if (facet == null || !facet.isRendered()) {
            TablePanelsRenderer.log("renderFilterPanel", "Filter panel not rendered, nothing to display");
            return;
        }
        this.renderPanelStart(context, component, writer, "_filterPanel", this.getTheme().getMessage("table.panel.filterTitle"), null);
        RenderingUtilities.renderComponent(facet, context);
        this.renderPanelEnd(writer);
    }

    protected void renderPreferencesPanel(FacesContext context, TablePanels component, ResponseWriter writer) throws IOException {
        if (component == null) {
            TablePanelsRenderer.log("renderPreferencesPanel", "Cannot render preferences panel, TablePanels is null");
            return;
        }
        Table table = component.getTableAncestor();
        UIComponent facet = table != null ? table.getFacet("preferencesPanel") : null;
        if (facet == null || !facet.isRendered()) {
            TablePanelsRenderer.log("renderPreferencesPanel", "Preferences panel not rendered, nothing to display");
            return;
        }
        this.renderPanelStart(context, component, writer, "_preferencesPanel", this.getTheme().getMessage("table.panel.preferencesTitle"), null);
        RenderingUtilities.renderComponent(facet, context);
        this.renderPanelEnd(writer);
    }

    protected void renderSortPanel(FacesContext context, TablePanels component, ResponseWriter writer) throws IOException {
        if (component == null) {
            TablePanelsRenderer.log("renderSortPanel", "Cannot render sort panel, TablePanels is null");
            return;
        }
        Theme theme = this.getTheme();
        this.renderPanelStart(context, component, writer, "_sortPanel", theme.getMessage("table.panel.sortTitle"), theme.getMessage("table.panel.help"));
        Table table = component.getTableAncestor();
        UIComponent facet = table != null ? table.getFacet("sortPanel") : null;
        if (facet != null && facet.isRendered()) {
            RenderingUtilities.renderComponent(facet, context);
        } else {
            this.renderSortPanelLayout(context, component, writer);
        }
        this.renderPanelEnd(writer);
    }

    protected void renderEnclosingTagStart(FacesContext context, TablePanels component, ResponseWriter writer) throws IOException {
        if (component == null) {
            TablePanelsRenderer.log("renderEnclosingTagStart", "Cannot render enclosing tag, TablePanels is null");
            return;
        }
        Theme theme = this.getTheme();
        writer.writeText((Object)"\n", null);
        writer.startElement("td", (UIComponent)component);
        writer.writeAttribute("id", (Object)component.getClientId(context), null);
        String extraHtml = RenderingUtilities.renderStyleClass(context, writer, (UIComponent)component, theme.getStyleClass("TABLE_PANEL_TD"), component.getExtraHtml());
        if (!(component.getColSpan() <= -1 || extraHtml != null && extraHtml.contains("colspan="))) {
            writer.writeAttribute("colspan", (Object)Integer.toString(component.getColSpan()), null);
        }
        if (!(component.getRowSpan() <= -1 || extraHtml != null && extraHtml.contains("rowspan="))) {
            writer.writeAttribute("rowspan", (Object)Integer.toString(component.getRowSpan()), null);
        }
        if (component.isNoWrap() && (extraHtml == null || !extraHtml.contains("nowrap="))) {
            writer.writeAttribute("nowrap", (Object)"nowrap", null);
        }
        if (!(component.getToolTip() == null || extraHtml != null && extraHtml.contains("title="))) {
            writer.writeAttribute("title", (Object)component.getToolTip(), "toolTip");
        }
        RenderingUtilities.writeStringAttributes((UIComponent)component, writer, STRING_ATTRIBUTES, extraHtml);
    }

    protected void renderEnclosingTagEnd(FacesContext context, TablePanels component, ResponseWriter writer) throws IOException {
        if (component == null) {
            TablePanelsRenderer.log("renderEnclosingTagEnd", "Cannot render enclosing tag, TablePanels is null");
            return;
        }
        writer.endElement("td");
    }

    private String getId(UIComponent component, String id) {
        FacesContext context = FacesContext.getCurrentInstance();
        String clientId = component.getClientId(context);
        return clientId + UINamingContainer.getSeparatorChar((FacesContext)context) + id;
    }

    private Theme getTheme() {
        return ThemeUtilities.getTheme(FacesContext.getCurrentInstance());
    }

    private static void log(String method, String msg) {
        Class<TablePanelsRenderer> clazz = TablePanelsRenderer.class;
        if (LogUtil.fineEnabled(clazz)) {
            LogUtil.fine(clazz, clazz.getName() + "." + method + ": " + msg);
        }
    }

    private void renderPanelStart(FacesContext context, TablePanels component, ResponseWriter writer, String id, String title, String tip) throws IOException {
        if (component == null) {
            TablePanelsRenderer.log("renderPanelStart", "Cannot render panel, TablePanels is null");
            return;
        }
        Theme theme = this.getTheme();
        writer.writeText((Object)"\n", null);
        writer.startElement("div", (UIComponent)component);
        writer.writeAttribute("id", (Object)this.getId((UIComponent)component, id), null);
        writer.writeAttribute("class", (Object)theme.getStyleClass("HIDDEN"), null);
        writer.writeText((Object)"\n", null);
        writer.startElement("div", (UIComponent)component);
        writer.writeAttribute("class", (Object)theme.getStyleClass("TABLE_PANEL_SHADOW3_DIV"), null);
        writer.writeText((Object)"\n", null);
        writer.startElement("div", (UIComponent)component);
        writer.writeAttribute("class", (Object)theme.getStyleClass("TABLE_PANEL_SHADOW2_DIV"), null);
        writer.writeText((Object)"\n", null);
        writer.startElement("div", (UIComponent)component);
        writer.writeAttribute("class", (Object)theme.getStyleClass("TABLE_PANEL_SHADOW1_DIV"), null);
        writer.writeText((Object)"\n", null);
        writer.startElement("div", (UIComponent)component);
        writer.writeAttribute("class", (Object)theme.getStyleClass("TABLE_PANEL_DIV"), null);
        if (tip != null) {
            writer.writeText((Object)"\n", null);
            writer.startElement("div", (UIComponent)component);
            writer.writeAttribute("class", (Object)theme.getStyleClass("TABLE_PANEL_HELP_TEXT"), null);
            writer.writeText((Object)tip, null);
            writer.endElement("div");
        }
        writer.writeText((Object)"\n", null);
        writer.startElement("div", (UIComponent)component);
        writer.writeAttribute("class", (Object)theme.getStyleClass("TABLE_PANEL_TITLE"), null);
        writer.writeText((Object)title, null);
        writer.endElement("div");
        writer.writeText((Object)"\n", null);
        writer.startElement("div", (UIComponent)component);
        writer.writeAttribute("class", (Object)theme.getStyleClass("TABLE_PANEL_CONTENT"), null);
    }

    private void renderPanelEnd(ResponseWriter writer) throws IOException {
        writer.endElement("div");
        writer.endElement("div");
        writer.endElement("div");
        writer.endElement("div");
        writer.endElement("div");
        writer.endElement("div");
    }

    private void renderSortPanelLayout(FacesContext context, TablePanels component, ResponseWriter writer) throws IOException {
        if (component == null) {
            TablePanelsRenderer.log("renderSortPanelLayout", "Cannot render sort panel layout, TablePanels is null");
            return;
        }
        Theme theme = this.getTheme();
        writer.writeText((Object)"\n", null);
        writer.startElement("table", (UIComponent)component);
        writer.writeAttribute("class", (Object)theme.getStyleClass("TABLE_PANEL_TABLE"), null);
        writer.writeAttribute("border", (Object)"0", null);
        writer.writeAttribute("cellpadding", (Object)"0", null);
        writer.writeAttribute("cellspacing", (Object)"0", null);
        this.renderSortPanelRow(context, component, writer, component.getPrimarySortColumnMenuLabel(), component.getPrimarySortColumnMenu(), component.getPrimarySortOrderMenu());
        UIComponent menu = component.getSecondarySortColumnMenu();
        Object options = menu instanceof DropDown ? (Option[])((DropDown)menu).getItems() : null;
        if (options != null && ((Option[])options).length > 2) {
            this.renderSortPanelRow(context, component, writer, component.getSecondarySortColumnMenuLabel(), menu, component.getSecondarySortOrderMenu());
        } else {
            TablePanelsRenderer.log("renderSortPanelLayout", "Secondary sort column menu not rendered");
        }
        menu = component.getTertiarySortColumnMenu();
        options = menu instanceof DropDown ? (Option[])((DropDown)menu).getItems() : null;
        if (options != null && ((Option[])options).length > 3) {
            this.renderSortPanelRow(context, component, writer, component.getTertiarySortColumnMenuLabel(), menu, component.getTertiarySortOrderMenu());
        } else {
            TablePanelsRenderer.log("renderSortPanelLayout", "Tertiary sort column menu not rendered");
        }
        writer.endElement("table");
        writer.writeText((Object)"\n", null);
        writer.startElement("div", (UIComponent)component);
        writer.writeAttribute("class", (Object)theme.getStyleClass("TABLE_PANEL_BUTTON_DIV"), null);
        RenderingUtilities.renderComponent(component.getSortPanelSubmitButton(), context);
        RenderingUtilities.renderComponent(component.getSortPanelCancelButton(), context);
        writer.endElement("div");
    }

    private void renderSortPanelRow(FacesContext context, TablePanels component, ResponseWriter writer, UIComponent label, UIComponent columnMenu, UIComponent orderMenu) throws IOException {
        if (component == null) {
            TablePanelsRenderer.log("renderSortPanelRow", "Cannot render sort panel row, TablePanels is null");
            return;
        }
        writer.writeText((Object)"\n", null);
        writer.startElement("tr", (UIComponent)component);
        writer.writeText((Object)"\n", null);
        writer.startElement("td", (UIComponent)component);
        if (label instanceof Label) {
            ((Label)label).setFor(columnMenu.getClientId(context));
            RenderingUtilities.renderComponent(label, context);
        } else {
            TablePanelsRenderer.log("renderSortPanelRow", "Cannot render label, not Label instance");
        }
        writer.endElement("td");
        writer.writeText((Object)"\n", null);
        writer.startElement("td", (UIComponent)component);
        RenderingUtilities.renderComponent(columnMenu, context);
        writer.endElement("td");
        writer.writeText((Object)"\n", null);
        writer.startElement("td", (UIComponent)component);
        RenderingUtilities.renderComponent(orderMenu, context);
        writer.endElement("td");
        writer.endElement("tr");
    }
}

